/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.invertedlist;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.ArcCosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.CosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.ArrayList;

public class InMemoryInvertedIndex<V extends NumberVector>
extends AbstractIndex<V>
implements KNNIndex<V>,
RangeIndex<V> {
    private static final Logging LOG = Logging.getLogger(InMemoryInvertedIndex.class);
    ArrayList<ModifiableDoubleDBIDList> index;
    WritableDoubleDataStore length;

    public InMemoryInvertedIndex(Relation<V> relation) {
        super(relation);
    }

    @Override
    public void initialize() {
        if (this.index != null) {
            LOG.warning("Index was already initialized!");
        }
        this.index = new ArrayList();
        this.length = DataStoreUtil.makeDoubleStorage(this.relation.getDBIDs(), 30);
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDIter);
            if (numberVector instanceof SparseNumberVector) {
                this.indexSparse(dBIDIter, (SparseNumberVector)numberVector);
            } else {
                this.indexDense(dBIDIter, numberVector);
            }
            dBIDIter.advance();
        }
        long l = 0L;
        for (ModifiableDoubleDBIDList modifiableDoubleDBIDList : this.index) {
            modifiableDoubleDBIDList.sort();
            l += (long)modifiableDoubleDBIDList.size();
        }
        double d = (double)l / ((double)this.index.size() * (double)this.relation.size());
        if (d > 0.2) {
            LOG.warning("Inverted list indexes only perform well for very sparse data. Your data set has a sparsity of " + d);
        }
    }

    private void indexSparse(DBIDRef dBIDRef, SparseNumberVector sparseNumberVector) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        while (sparseNumberVector.iterValid(n)) {
            int n2 = sparseNumberVector.iterDim(n);
            double d2 = sparseNumberVector.iterDoubleValue(n);
            if (d2 != 0.0 && d2 == d2) {
                d += d2 * d2;
                this.getOrCreateColumn(n2).add(d2, dBIDRef);
            }
            n = sparseNumberVector.iterAdvance(n);
        }
        this.length.put(dBIDRef, d);
    }

    private void indexDense(DBIDRef dBIDRef, V v) {
        double d = 0.0;
        int n = v.getDimensionality();
        for (int i = 0; i < n; ++i) {
            double d2 = v.doubleValue(i);
            if (d2 == 0.0 || d2 != d2) continue;
            d += d2 * d2;
            this.getOrCreateColumn(i).add(d2, dBIDRef);
        }
        this.length.put(dBIDRef, Math.sqrt(d));
    }

    private ModifiableDoubleDBIDList getOrCreateColumn(int n) {
        while (n >= this.index.size()) {
            this.index.add(DBIDUtil.newDistanceDBIDList());
        }
        return this.index.get(n);
    }

    private double naiveQuerySparse(SparseNumberVector sparseNumberVector, WritableDoubleDataStore writableDoubleDataStore, HashSetModifiableDBIDs hashSetModifiableDBIDs) {
        double d = 0.0;
        int n = sparseNumberVector.iter();
        while (sparseNumberVector.iterValid(n)) {
            int n2 = sparseNumberVector.iterDim(n);
            double d2 = sparseNumberVector.iterDoubleValue(n);
            if (d2 != 0.0 && d2 == d2) {
                d += d2 * d2;
                if (n2 < this.index.size()) {
                    ModifiableDoubleDBIDList modifiableDoubleDBIDList = this.index.get(n2);
                    DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
                    while (doubleDBIDListMIter.valid()) {
                        writableDoubleDataStore.increment(doubleDBIDListMIter, doubleDBIDListMIter.doubleValue() * d2);
                        hashSetModifiableDBIDs.add(doubleDBIDListMIter);
                        doubleDBIDListMIter.advance();
                    }
                }
            }
            n = sparseNumberVector.iterAdvance(n);
        }
        return Math.sqrt(d);
    }

    private double naiveQueryDense(NumberVector numberVector, WritableDoubleDataStore writableDoubleDataStore, HashSetModifiableDBIDs hashSetModifiableDBIDs) {
        double d = 0.0;
        int n = numberVector.getDimensionality();
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i);
            if (d2 == 0.0 || d2 != d2) continue;
            d += d2 * d2;
            if (i >= this.index.size()) continue;
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = this.index.get(i);
            DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
            while (doubleDBIDListMIter.valid()) {
                writableDoubleDataStore.increment(doubleDBIDListMIter, doubleDBIDListMIter.doubleValue() * d2);
                hashSetModifiableDBIDs.add(doubleDBIDListMIter);
                doubleDBIDListMIter.advance();
            }
        }
        return Math.sqrt(d);
    }

    private double naiveQuery(V v, WritableDoubleDataStore writableDoubleDataStore, HashSetModifiableDBIDs hashSetModifiableDBIDs) {
        if (v instanceof SparseNumberVector) {
            return this.naiveQuerySparse((SparseNumberVector)v, writableDoubleDataStore, hashSetModifiableDBIDs);
        }
        return this.naiveQueryDense((NumberVector)v, writableDoubleDataStore, hashSetModifiableDBIDs);
    }

    @Override
    public void logStatistics() {
        long l = 0L;
        for (ModifiableDoubleDBIDList modifiableDoubleDBIDList : this.index) {
            l += (long)modifiableDoubleDBIDList.size();
        }
        double d = (double)l / ((double)this.index.size() * (double)this.relation.size());
        LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".sparsity", d));
    }

    @Override
    public KNNQuery<V> getKNNQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
        DistanceFunction<V> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof CosineDistanceFunction) {
            return new CosineKNNQuery(distanceQuery);
        }
        if (distanceFunction instanceof ArcCosineDistanceFunction) {
            return new ArcCosineKNNQuery(distanceQuery);
        }
        return null;
    }

    @Override
    public RangeQuery<V> getRangeQuery(DistanceQuery<V> distanceQuery, Object ... objectArray) {
        DistanceFunction<V> distanceFunction = distanceQuery.getDistanceFunction();
        if (distanceFunction instanceof CosineDistanceFunction) {
            return new CosineRangeQuery(distanceQuery);
        }
        if (distanceFunction instanceof ArcCosineDistanceFunction) {
            return new ArcCosineRangeQuery(distanceQuery);
        }
        return null;
    }

    @Override
    public String getLongName() {
        return "Inverted lists index";
    }

    @Override
    public String getShortName() {
        return "inverted-lists";
    }

    public static class Factory<V extends NumberVector>
    implements IndexFactory<V, InMemoryInvertedIndex<V>> {
        @Override
        public InMemoryInvertedIndex<V> instantiate(Relation<V> relation) {
            return new InMemoryInvertedIndex<V>(relation);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_VARIABLE_LENGTH;
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractParameterizer {
            @Override
            protected Factory<V> makeInstance() {
                return new Factory();
            }
        }
    }

    protected class ArcCosineRangeQuery
    extends AbstractDistanceRangeQuery<V> {
        public ArcCosineRangeQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public void getRangeForObject(V v, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(hashSetModifiableDBIDs, 3, 0.0);
            double d2 = InMemoryInvertedIndex.this.naiveQuery(v, writableDoubleDataStore, hashSetModifiableDBIDs);
            double d3 = Math.cos(d) * d2;
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                double d4 = writableDoubleDataStore.doubleValue(dBIDMIter) / InMemoryInvertedIndex.this.length.doubleValue(dBIDMIter);
                if (d4 >= d3) {
                    modifiableDoubleDBIDList.add(Math.acos(d4 / d2), dBIDMIter);
                }
                dBIDMIter.advance();
            }
        }
    }

    protected class CosineRangeQuery
    extends AbstractDistanceRangeQuery<V> {
        public CosineRangeQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public void getRangeForObject(V v, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(hashSetModifiableDBIDs, 3, 0.0);
            double d2 = InMemoryInvertedIndex.this.naiveQuery(v, writableDoubleDataStore, hashSetModifiableDBIDs);
            double d3 = (1.0 - d) * d2;
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                double d4 = writableDoubleDataStore.doubleValue(dBIDMIter) / InMemoryInvertedIndex.this.length.doubleValue(dBIDMIter);
                if (d4 >= d3) {
                    modifiableDoubleDBIDList.add(1.0 - d4 / d2, dBIDMIter);
                }
                dBIDMIter.advance();
            }
        }
    }

    protected class ArcCosineKNNQuery
    extends AbstractDistanceKNNQuery<V> {
        public ArcCosineKNNQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(V v, int n) {
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(hashSetModifiableDBIDs, 3, 0.0);
            double d = InMemoryInvertedIndex.this.naiveQuery(v, writableDoubleDataStore, hashSetModifiableDBIDs);
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                double d2 = Math.acos(writableDoubleDataStore.doubleValue(dBIDMIter) / (InMemoryInvertedIndex.this.length.doubleValue(dBIDMIter) * d));
                if (kNNHeap.getKNNDistance() >= d2) {
                    kNNHeap.insert(d2, dBIDMIter);
                }
                dBIDMIter.advance();
            }
            return kNNHeap.toKNNList();
        }
    }

    protected class CosineKNNQuery
    extends AbstractDistanceKNNQuery<V> {
        public CosineKNNQuery(DistanceQuery<V> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(V v, int n) {
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
            WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(hashSetModifiableDBIDs, 3, 0.0);
            double d = InMemoryInvertedIndex.this.naiveQuery(v, writableDoubleDataStore, hashSetModifiableDBIDs);
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                double d2 = 1.0 - writableDoubleDataStore.doubleValue(dBIDMIter) / (InMemoryInvertedIndex.this.length.doubleValue(dBIDMIter) * d);
                if (kNNHeap.getKNNDistance() >= d2) {
                    kNNHeap.insert(d2, dBIDMIter);
                }
                dBIDMIter.advance();
            }
            return kNNHeap.toKNNList();
        }
    }
}

