/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.PreprocessorRKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

@Title(value="Materialize kNN and RkNN Neighborhood preprocessor")
@Description(value="Materializes the k nearest neighbors and the reverse k nearest neighbors of objects of a database.")
public class MaterializeKNNAndRKNNPreprocessor<O>
extends MaterializeKNNPreprocessor<O>
implements RKNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(MaterializeKNNAndRKNNPreprocessor.class);
    private WritableDataStore<TreeSet<DoubleDBIDPair>> materialized_RkNN;

    public MaterializeKNNAndRKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n) {
        super(relation, distanceFunction, n);
    }

    @Override
    protected void preprocess() {
        this.createStorage();
        this.materialized_RkNN = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 2, TreeSet.class);
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress("Materializing k nearest neighbors and reverse k nearest neighbors (k=" + this.k + ")", this.relation.size(), this.getLogger()) : null;
        this.materializeKNNAndRKNNs(DBIDUtil.ensureArray(this.relation.getDBIDs()), finiteProgress);
    }

    private void materializeKNNAndRKNNs(ArrayDBIDs arrayDBIDs, FiniteProgress finiteProgress) {
        Object object = arrayDBIDs.iter();
        while (object.valid()) {
            if (this.materialized_RkNN.get((DBIDRef)object) == null) {
                this.materialized_RkNN.put((DBIDRef)object, new TreeSet());
            }
            object.advance();
        }
        object = this.knnQuery.getKNNForBulkDBIDs(arrayDBIDs, this.k);
        int n = 0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            KNNList kNNList = (KNNList)object.get(n);
            this.storage.put(dBIDArrayIter, kNNList);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                TreeSet treeSet = (TreeSet)this.materialized_RkNN.get(doubleDBIDListIter);
                treeSet.add(this.makePair(doubleDBIDListIter, dBIDArrayIter));
                doubleDBIDListIter.advance();
            }
            this.getLogger().incrementProcessed(finiteProgress);
            dBIDArrayIter.advance();
            ++n;
        }
        this.getLogger().ensureCompleted(finiteProgress);
    }

    private DoubleDBIDPair makePair(DoubleDBIDListIter doubleDBIDListIter, DBIDIter dBIDIter) {
        return DBIDUtil.newPair(doubleDBIDListIter.getPair().doubleValue(), (DBIDRef)dBIDIter);
    }

    @Override
    protected void objectsInserted(DBIDs dBIDs) {
        StepProgress stepProgress = this.getLogger().isVerbose() ? new StepProgress(3) : null;
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
        this.getLogger().beginStep(stepProgress, 1, "New insertions ocurred, materialize their new kNNs and RkNNs.");
        this.materializeKNNAndRKNNs(arrayDBIDs, null);
        this.getLogger().beginStep(stepProgress, 2, "New insertions ocurred, update the affected kNNs and RkNNs.");
        ArrayDBIDs arrayDBIDs2 = this.updateKNNsAndRkNNs(dBIDs);
        this.getLogger().beginStep(stepProgress, 3, "New insertions ocurred, inform listeners.");
        this.fireKNNsInserted(dBIDs, arrayDBIDs2);
        this.getLogger().ensureCompleted(stepProgress);
    }

    private ArrayDBIDs updateKNNsAndRkNNs(DBIDs dBIDs) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        ModifiableDBIDs modifiableDBIDs = DBIDUtil.difference(this.relation.getDBIDs(), dBIDs);
        DBIDIter dBIDIter = modifiableDBIDs.iter();
        while (dBIDIter.valid()) {
            KNNList kNNList = (KNNList)this.storage.get(dBIDIter);
            double d = kNNList.getKNNDistance();
            KNNHeap kNNHeap = null;
            Object object = dBIDs.iter();
            while (object.valid()) {
                double d2 = this.distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)object);
                if (d2 <= d) {
                    if (kNNHeap == null) {
                        kNNHeap = DBIDUtil.newHeap(kNNList);
                    }
                    kNNHeap.insert(d2, (DBIDRef)object);
                }
                object.advance();
            }
            if (kNNHeap != null) {
                Object object2;
                DBIDRef dBIDRef;
                object = kNNHeap.toKNNList();
                this.storage.put(dBIDIter, object);
                int n = 0;
                int n2 = 0;
                ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
                ModifiableDoubleDBIDList modifiableDoubleDBIDList2 = DBIDUtil.newDistanceDBIDList();
                while (n < kNNList.size() && n2 < object.size()) {
                    dBIDRef = kNNList.get(n);
                    if (!DBIDUtil.equal(dBIDRef, (DBIDRef)(object2 = object.get(n2)))) {
                        modifiableDoubleDBIDList.add((DoubleDBIDPair)object2);
                        ++n2;
                        continue;
                    }
                    ++n;
                    ++n2;
                }
                if (n != n2) {
                    while (n < kNNList.size()) {
                        modifiableDoubleDBIDList2.add(kNNList.get(n));
                        ++n;
                    }
                    while (n2 < object.size()) {
                        modifiableDoubleDBIDList.add(object.get(n));
                        ++n;
                    }
                }
                dBIDRef = modifiableDoubleDBIDList.iter();
                while (dBIDRef.valid()) {
                    object2 = (TreeSet)this.materialized_RkNN.get(dBIDRef);
                    ((TreeSet)object2).add(this.makePair((DoubleDBIDListIter)dBIDRef, dBIDIter));
                    dBIDRef.advance();
                }
                dBIDRef = modifiableDoubleDBIDList2.iter();
                while (dBIDRef.valid()) {
                    object2 = (TreeSet)this.materialized_RkNN.get(dBIDRef);
                    ((TreeSet)object2).remove(this.makePair((DoubleDBIDListIter)dBIDRef, dBIDIter));
                    dBIDRef.advance();
                }
                arrayModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return arrayModifiableDBIDs;
    }

    @Override
    protected void objectsRemoved(DBIDs dBIDs) {
        Object object;
        Object object22;
        Iterator iterator;
        StepProgress stepProgress = this.getLogger().isVerbose() ? new StepProgress(3) : null;
        SetDBIDs setDBIDs = DBIDUtil.ensureSet(this.distanceQuery.getRelation().getDBIDs());
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
        this.getLogger().beginStep(stepProgress, 1, "New deletions ocurred, remove their materialized kNNs and RkNNs.");
        ArrayList arrayList = new ArrayList(dBIDs.size());
        ArrayList arrayList2 = new ArrayList(dBIDs.size());
        Object object3 = arrayDBIDs.iter();
        while (object3.valid()) {
            arrayList.add(this.storage.get((DBIDRef)object3));
            iterator = ((KNNList)this.storage.get((DBIDRef)object3)).iter();
            while (iterator.valid()) {
                if (!setDBIDs.contains((DBIDRef)((Object)iterator)) && !dBIDs.contains((DBIDRef)((Object)iterator))) {
                    LOG.warning("False kNN: " + iterator);
                }
                iterator.advance();
            }
            this.storage.delete((DBIDRef)object3);
            arrayList2.add(this.materialized_RkNN.get((DBIDRef)object3));
            for (Object object22 : (TreeSet)this.materialized_RkNN.get((DBIDRef)object3)) {
                if (setDBIDs.contains((DBIDRef)object22) || dBIDs.contains((DBIDRef)object22)) continue;
                LOG.warning("False RkNN: " + object22);
            }
            this.materialized_RkNN.delete((DBIDRef)object3);
            object3.advance();
        }
        object3 = this.affectedkNN(arrayList, arrayDBIDs);
        iterator = this.affectedRkNN(arrayList2, arrayDBIDs);
        this.getLogger().beginStep(stepProgress, 2, "New deletions ocurred, update the affected kNNs and RkNNs.");
        object22 = this.knnQuery.getKNNForBulkDBIDs((ArrayDBIDs)((Object)iterator), this.k);
        int n = 0;
        Object object4 = iterator.iter();
        while (object4.valid()) {
            if (object22.get(n) == null && !setDBIDs.contains((DBIDRef)object4)) {
                LOG.warning("BUG in online kNN/RkNN maintainance: " + DBIDUtil.toString((DBIDRef)object4) + " no longer in database.");
            } else {
                assert (object22.get(n) != null);
                this.storage.put((DBIDRef)object4, object22.get(n));
                object = ((KNNList)object22.get(n)).iter();
                while (object.valid()) {
                    ((TreeSet)this.materialized_RkNN.get((DBIDRef)object)).add(this.makePair((DoubleDBIDListIter)object, (DBIDIter)object4));
                    object.advance();
                }
            }
            object4.advance();
            ++n;
        }
        object22 = DBIDUtil.ensureSet(dBIDs);
        DBIDArrayIter dBIDArrayIter = object3.iter();
        while (dBIDArrayIter.valid()) {
            object4 = (TreeSet)this.materialized_RkNN.get(dBIDArrayIter);
            object = ((TreeSet)object4).iterator();
            while (object.hasNext()) {
                if (!object22.contains((DBIDRef)object.next())) continue;
                object.remove();
            }
            dBIDArrayIter.advance();
        }
        this.getLogger().beginStep(stepProgress, 3, "New deletions ocurred, inform listeners.");
        this.fireKNNsRemoved(dBIDs, (DBIDs)((Object)iterator));
        this.getLogger().ensureCompleted(stepProgress);
    }

    protected ArrayDBIDs affectedkNN(List<? extends KNNList> list, DBIDs dBIDs) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        for (KNNList kNNList : list) {
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                hashSetModifiableDBIDs.add(doubleDBIDListIter);
                doubleDBIDListIter.advance();
            }
        }
        hashSetModifiableDBIDs.removeDBIDs(dBIDs);
        return DBIDUtil.newArray(hashSetModifiableDBIDs);
    }

    protected ArrayDBIDs affectedRkNN(List<? extends Collection<DoubleDBIDPair>> list, DBIDs dBIDs) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        for (Collection<DoubleDBIDPair> collection : list) {
            for (DoubleDBIDPair doubleDBIDPair : collection) {
                hashSetModifiableDBIDs.add(doubleDBIDPair);
            }
        }
        hashSetModifiableDBIDs.removeDBIDs(dBIDs);
        return DBIDUtil.newArray(hashSetModifiableDBIDs);
    }

    public KNNList getKNN(DBID dBID) {
        return (KNNList)this.storage.get(dBID);
    }

    public DoubleDBIDList getRKNN(DBIDRef dBIDRef) {
        TreeSet treeSet = (TreeSet)this.materialized_RkNN.get(dBIDRef);
        if (treeSet == null) {
            return null;
        }
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(treeSet.size());
        for (DoubleDBIDPair doubleDBIDPair : treeSet) {
            modifiableDoubleDBIDList.add(doubleDBIDPair);
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!this.distanceFunction.equals(distanceQuery.getDistanceFunction())) {
            return null;
        }
        for (Object object : objectArray) {
            if (!(object instanceof Integer)) continue;
            if ((Integer)object <= this.k) break;
            return null;
        }
        return new PreprocessorRKNNQuery(this.relation, this);
    }

    @Override
    public String getLongName() {
        return "kNN and RkNN Preprocessor";
    }

    @Override
    public String getShortName() {
        return "knn and rknn preprocessor";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Factory<O>
    extends MaterializeKNNPreprocessor.Factory<O> {
        public Factory(int n, DistanceFunction<? super O> distanceFunction) {
            super(n, distanceFunction);
        }

        @Override
        public MaterializeKNNAndRKNNPreprocessor<O> instantiate(Relation<O> relation) {
            MaterializeKNNAndRKNNPreprocessor<O> materializeKNNAndRKNNPreprocessor = new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.distanceFunction, this.k);
            return materializeKNNAndRKNNPreprocessor;
        }

        public static class Parameterizer<O>
        extends MaterializeKNNPreprocessor.Factory.Parameterizer<O> {
            @Override
            protected Factory<O> makeInstance() {
                return new Factory(this.k, this.distanceFunction);
            }
        }
    }
}

