/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTreeUnified;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkmax.MkMaxTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.List;
import java.util.Map;

public abstract class MkMaxTree<O>
extends AbstractMkTreeUnified<O, MkMaxTreeNode<O>, MkMaxEntry, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry>> {
    private static final Logging LOG = Logging.getLogger(MkMaxTree.class);

    public MkMaxTree(Relation<O> relation, PageFile<MkMaxTreeNode<O>> pageFile, MkTreeSettings<O, MkMaxTreeNode<O>, MkMaxEntry> mkTreeSettings) {
        super(relation, pageFile, mkTreeSettings);
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef dBIDRef, int n) {
        if (n > this.getKmax()) {
            throw new IllegalArgumentException("Parameter k has to be equal or less than parameter k of the MkMax-Tree!");
        }
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNNQuery(dBIDRef, (MkMaxTreeNode)this.getRoot(), null, modifiableDoubleDBIDList);
        if (n == this.getKmax()) {
            modifiableDoubleDBIDList.sort();
            return modifiableDoubleDBIDList;
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(modifiableDoubleDBIDList.size());
        Object object = modifiableDoubleDBIDList.iter();
        while (object.valid()) {
            arrayModifiableDBIDs.add((DBIDRef)object);
            object.advance();
        }
        object = this.batchNN((AbstractMTreeNode)this.getRoot(), arrayModifiableDBIDs, n);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList2 = DBIDUtil.newDistanceDBIDList();
        DBIDMIter dBIDMIter = arrayModifiableDBIDs.iter();
        while (dBIDMIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDMIter);
            KNNList kNNList = (KNNList)object.get(dBID);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (DBIDUtil.equal(dBIDRef, doubleDBIDListIter)) {
                    modifiableDoubleDBIDList2.add(doubleDBIDListIter.doubleValue(), dBID);
                    break;
                }
                doubleDBIDListIter.advance();
            }
            dBIDMIter.advance();
        }
        modifiableDoubleDBIDList2.sort();
        return modifiableDoubleDBIDList2;
    }

    @Override
    protected void preInsert(MkMaxEntry mkMaxEntry) {
        KNNHeap kNNHeap = DBIDUtil.newHeap(this.getKmax());
        this.preInsert(mkMaxEntry, (MkMaxEntry)this.getRootEntry(), kNNHeap);
    }

    @Override
    protected void kNNdistanceAdjustment(MkMaxEntry mkMaxEntry, Map<DBID, KNNList> map) {
        MkMaxTreeNode mkMaxTreeNode = (MkMaxTreeNode)this.getNode(mkMaxEntry);
        double d = 0.0;
        if (mkMaxTreeNode.isLeaf()) {
            for (int i = 0; i < mkMaxTreeNode.getNumEntries(); ++i) {
                MkMaxEntry mkMaxEntry2 = (MkMaxEntry)mkMaxTreeNode.getEntry(i);
                mkMaxEntry2.setKnnDistance(map.get(mkMaxEntry2.getRoutingObjectID()).getKNNDistance());
                d = Math.max(d, mkMaxEntry2.getKnnDistance());
            }
        } else {
            for (int i = 0; i < mkMaxTreeNode.getNumEntries(); ++i) {
                MkMaxEntry mkMaxEntry3 = (MkMaxEntry)mkMaxTreeNode.getEntry(i);
                this.kNNdistanceAdjustment(mkMaxEntry3, map);
                d = Math.max(d, mkMaxEntry3.getKnnDistance());
            }
        }
        mkMaxEntry.setKnnDistance(d);
    }

    private void doReverseKNNQuery(DBIDRef dBIDRef, MkMaxTreeNode<O> mkMaxTreeNode, MkMaxEntry mkMaxEntry, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        if (mkMaxTreeNode.isLeaf()) {
            for (int i = 0; i < mkMaxTreeNode.getNumEntries(); ++i) {
                MkMaxEntry mkMaxEntry2 = (MkMaxEntry)mkMaxTreeNode.getEntry(i);
                double d = this.distance(mkMaxEntry2.getRoutingObjectID(), dBIDRef);
                if (!(d <= mkMaxEntry2.getKnnDistance())) continue;
                modifiableDoubleDBIDList.add(d, mkMaxEntry2.getRoutingObjectID());
            }
        } else {
            for (int i = 0; i < mkMaxTreeNode.getNumEntries(); ++i) {
                double d;
                MkMaxEntry mkMaxEntry3 = (MkMaxEntry)mkMaxTreeNode.getEntry(i);
                double d2 = mkMaxEntry != null ? mkMaxEntry.getKnnDistance() : Double.POSITIVE_INFINITY;
                double d3 = this.distance(mkMaxEntry3.getRoutingObjectID(), dBIDRef);
                double d4 = d = mkMaxEntry3.getCoveringRadius() > d3 ? 0.0 : d3 - mkMaxEntry3.getCoveringRadius();
                if (!(d <= d2)) continue;
                MkMaxTreeNode mkMaxTreeNode2 = (MkMaxTreeNode)this.getNode(mkMaxEntry3);
                this.doReverseKNNQuery(dBIDRef, mkMaxTreeNode2, mkMaxEntry3, modifiableDoubleDBIDList);
            }
        }
    }

    private void preInsert(MkMaxEntry mkMaxEntry, MkMaxEntry mkMaxEntry2, KNNHeap kNNHeap) {
        if (LOG.isDebugging()) {
            LOG.debugFine("preInsert " + mkMaxEntry + " - " + mkMaxEntry2 + "\n");
        }
        double d = kNNHeap.getKNNDistance();
        MkMaxTreeNode mkMaxTreeNode = (MkMaxTreeNode)this.getNode(mkMaxEntry2);
        double d2 = 0.0;
        if (mkMaxTreeNode.isLeaf()) {
            for (int i = 0; i < mkMaxTreeNode.getNumEntries(); ++i) {
                MkMaxEntry mkMaxEntry3 = (MkMaxEntry)mkMaxTreeNode.getEntry(i);
                double d3 = this.distance(mkMaxEntry3.getRoutingObjectID(), mkMaxEntry.getRoutingObjectID());
                if (d3 <= d) {
                    kNNHeap.insert(d3, mkMaxEntry3.getRoutingObjectID());
                    if (kNNHeap.size() >= this.getKmax()) {
                        d = kNNHeap.getKNNDistance();
                        mkMaxEntry.setKnnDistance(d);
                    }
                }
                if (d3 <= mkMaxEntry3.getKnnDistance()) {
                    KNNList kNNList = this.knnq.getKNNForDBID(mkMaxEntry3.getRoutingObjectID(), this.getKmax() - 1);
                    if (kNNList.size() + 1 < this.getKmax()) {
                        mkMaxEntry3.setKnnDistance(Double.NaN);
                    } else {
                        double d4 = Math.max(d3, kNNList.getKNNDistance());
                        mkMaxEntry3.setKnnDistance(d4);
                    }
                }
                d2 = Math.max(d2, mkMaxEntry3.getKnnDistance());
            }
        } else {
            List<DoubleIntPair> list = this.getSortedEntries(mkMaxTreeNode, mkMaxEntry.getRoutingObjectID());
            for (DoubleIntPair doubleIntPair : list) {
                MkMaxEntry mkMaxEntry4 = (MkMaxEntry)mkMaxTreeNode.getEntry(doubleIntPair.second);
                double d5 = mkMaxEntry4.getKnnDistance();
                if ((double)doubleIntPair.second < d5 || (double)doubleIntPair.second < d) {
                    this.preInsert(mkMaxEntry, mkMaxEntry4, kNNHeap);
                    d = kNNHeap.getKNNDistance();
                }
                d2 = Math.max(d2, mkMaxEntry4.getKnnDistance());
            }
        }
        if (LOG.isDebugging()) {
            LOG.debugFine(mkMaxEntry2 + "set knn dist " + d2);
        }
        mkMaxEntry2.setKnnDistance(d2);
    }

    @Override
    protected void initializeCapacities(MkMaxEntry mkMaxEntry) {
        int n = 8;
        double d = 12.125;
        if ((double)this.getPageSize() - d < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - d) / (8 + 3 * n) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - d) / (4 + 2 * n) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
    }

    @Override
    protected MkMaxTreeNode<O> createNewLeafNode() {
        return new MkMaxTreeNode(this.leafCapacity, true);
    }

    @Override
    protected MkMaxTreeNode<O> createNewDirectoryNode() {
        return new MkMaxTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkMaxEntry createNewDirectoryEntry(MkMaxTreeNode<O> mkMaxTreeNode, DBID dBID, double d) {
        return new MkMaxDirectoryEntry(dBID, d, mkMaxTreeNode.getPageID(), mkMaxTreeNode.coveringRadiusFromEntries(dBID, this), mkMaxTreeNode.kNNDistance());
    }

    @Override
    protected MkMaxEntry createRootEntry() {
        return new MkMaxDirectoryEntry(null, 0.0, 0, 0.0, 0.0);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

