/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.Util;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import java.util.Random;

@Reference(authors="C. H. Ang and T. C. Tan", title="New linear node splitting algorithm for R-trees", booktitle="Proceedings of the 5th International Symposium on Advances in Spatial Databases", url="http://dx.doi.org/10.1007/3-540-63238-7_38")
public class AngTanLinearSplit
implements SplitStrategy {
    private static final Logging LOG = Logging.getLogger(AngTanLinearSplit.class);
    public static final AngTanLinearSplit STATIC = new AngTanLinearSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A a, ArrayAdapter<E, A> arrayAdapter, int n) {
        double d;
        int n2;
        int n3;
        int n4 = arrayAdapter.size(a);
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox((SpatialComparable)arrayAdapter.get(a, 0));
        for (n3 = 1; n3 < n4; ++n3) {
            modifiableHyperBoundingBox.extend((SpatialComparable)arrayAdapter.get(a, n3));
        }
        n3 = modifiableHyperBoundingBox.getDimensionality();
        long[][] lArray = new long[n3][n4];
        for (n2 = 0; n2 < n4; ++n2) {
            SpatialComparable spatialComparable = (SpatialComparable)arrayAdapter.get(a, n2);
            for (int i = 0; i < n3; ++i) {
                double d2;
                d = spatialComparable.getMin(i) - modifiableHyperBoundingBox.getMin(i);
                if (!(d >= (d2 = modifiableHyperBoundingBox.getMax(i) - spatialComparable.getMax(i)))) continue;
                BitsUtil.setI(lArray[i], n2);
            }
        }
        n2 = -1;
        int n5 = Integer.MAX_VALUE;
        long[] lArray2 = null;
        d = Double.NaN;
        for (int i = 0; i < n3; ++i) {
            double d3;
            long[] lArray3 = lArray[i];
            int n6 = BitsUtil.cardinality(lArray3);
            if ((n6 = Math.max(n6, n4 - n6)) == n4) continue;
            if (n6 < n5) {
                n2 = i;
                n5 = n6;
                lArray2 = lArray3;
                d = Double.NaN;
                continue;
            }
            if (n6 != n5) continue;
            if (Double.isNaN(d)) {
                d = this.computeOverlap(a, arrayAdapter, lArray2);
            }
            if ((d3 = this.computeOverlap(a, arrayAdapter, lArray3)) < d) {
                n2 = i;
                n5 = n6;
                lArray2 = lArray3;
                d = d3;
                continue;
            }
            if (d3 != d) continue;
            double d4 = modifiableHyperBoundingBox.getMax(n2) - modifiableHyperBoundingBox.getMin(n2);
            double d5 = modifiableHyperBoundingBox.getMax(i) - modifiableHyperBoundingBox.getMin(i);
            if (!(d5 < d4)) continue;
            n2 = i;
            n5 = n6;
            lArray2 = lArray3;
            d = d3;
        }
        if (lArray2 == null) {
            LOG.warning("No Ang-Tan-Split found. Probably all points are the same? Returning random split.");
            return Util.randomBitSet(n4 >> 1, n4, new Random());
        }
        return lArray2;
    }

    protected <E extends SpatialComparable, A> double computeOverlap(A a, ArrayAdapter<E, A> arrayAdapter, long[] lArray) {
        ModifiableHyperBoundingBox modifiableHyperBoundingBox = null;
        ModifiableHyperBoundingBox modifiableHyperBoundingBox2 = null;
        for (int i = 0; i < arrayAdapter.size(a); ++i) {
            SpatialComparable spatialComparable = (SpatialComparable)arrayAdapter.get(a, i);
            if (BitsUtil.get(lArray, i)) {
                if (modifiableHyperBoundingBox == null) {
                    modifiableHyperBoundingBox = new ModifiableHyperBoundingBox(spatialComparable);
                    continue;
                }
                modifiableHyperBoundingBox.extend(spatialComparable);
                continue;
            }
            if (modifiableHyperBoundingBox2 == null) {
                modifiableHyperBoundingBox2 = new ModifiableHyperBoundingBox(spatialComparable);
                continue;
            }
            modifiableHyperBoundingBox2.extend(spatialComparable);
        }
        if (modifiableHyperBoundingBox == null || modifiableHyperBoundingBox2 == null) {
            throw new AbortException("Invalid state in split: one of the sets is empty.");
        }
        return SpatialUtil.overlap(modifiableHyperBoundingBox, modifiableHyperBoundingBox2);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected AngTanLinearSplit makeInstance() {
            return STATIC;
        }
    }
}

