/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging.progress;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.Progress;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractProgress
implements Progress {
    private AtomicInteger processed = new AtomicInteger(0);
    private String task;
    private long lastLogged = Long.MIN_VALUE;

    public AbstractProgress(String string) {
        this.task = string;
    }

    public String getTask() {
        return this.task;
    }

    protected void setProcessed(int n) throws IllegalArgumentException {
        this.processed.set(n);
    }

    public void setProcessed(int n, Logging logging) throws IllegalArgumentException {
        this.setProcessed(n);
        if (this.testLoggingRate()) {
            logging.progress(this);
        }
    }

    public int getProcessed() {
        return this.processed.get();
    }

    @Override
    public abstract StringBuilder appendToBuffer(StringBuilder var1);

    @Override
    public String toString() {
        return this.appendToBuffer(new StringBuilder()).toString();
    }

    public void incrementProcessed(Logging logging) {
        this.processed.incrementAndGet();
        if (this.testLoggingRate()) {
            logging.progress(this);
        }
    }

    protected boolean testLoggingRate() {
        if (this.isComplete() || this.getProcessed() < 10) {
            return true;
        }
        long l = System.nanoTime();
        if ((double)this.lastLogged > (double)l - 1.0E8) {
            return false;
        }
        this.lastLogged = l;
        return true;
    }
}

