/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.MathUtil;

public abstract class SinCosTable {
    protected final int steps;

    private SinCosTable(int n) {
        this.steps = n;
    }

    public abstract double cos(int var1);

    public abstract double sin(int var1);

    public static SinCosTable make(int n) {
        if ((n & 3) == 0) {
            return new QuarterTable(n);
        }
        if ((n & 1) == 0) {
            return new HalfTable(n);
        }
        return new FullTable(n);
    }

    private static class QuarterTable
    extends SinCosTable {
        private final int quarsteps;
        private final int halfsteps;
        private final double[] costable;

        public QuarterTable(int n) {
            super(n);
            this.halfsteps = n >> 1;
            this.quarsteps = n >> 2;
            double d = Math.toRadians(360.0 / (double)n);
            this.costable = new double[this.quarsteps + 1];
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.quarsteps + 1) {
                this.costable[n2] = Math.cos(d2);
                ++n2;
                d2 += d;
            }
        }

        @Override
        public double cos(int n) {
            if ((n = Math.abs(n) % this.steps) < this.costable.length) {
                return this.costable[n];
            }
            if (n > this.halfsteps && (n = this.steps - n) < this.costable.length) {
                return this.costable[n];
            }
            n = this.halfsteps - n;
            return -this.costable[n];
        }

        @Override
        public double sin(int n) {
            return -this.cos(n + this.quarsteps);
        }
    }

    private static class HalfTable
    extends SinCosTable {
        private final int halfsteps;
        private final double[] costable;
        private final double[] sintable;

        public HalfTable(int n) {
            super(n);
            this.halfsteps = n >> 1;
            double d = Math.toRadians(360.0 / (double)n);
            this.costable = new double[this.halfsteps + 1];
            this.sintable = new double[this.halfsteps + 1];
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.halfsteps + 1) {
                this.costable[n2] = Math.cos(d2);
                this.sintable[n2] = Math.sin(d2);
                ++n2;
                d2 += d;
            }
        }

        @Override
        public double cos(int n) {
            if ((n = Math.abs(n) % this.steps) < this.costable.length) {
                return this.costable[n];
            }
            return this.costable[this.steps - n];
        }

        @Override
        public double sin(int n) {
            if ((n %= this.steps) < 0) {
                n += this.steps;
            }
            if (n < this.sintable.length) {
                return this.sintable[n];
            }
            return -this.sintable[this.steps - n];
        }
    }

    private static class FullTable
    extends SinCosTable {
        private final double[] costable;
        private final double[] sintable;

        public FullTable(int n) {
            super(n);
            double d = Math.toRadians(360.0 / (double)n);
            this.costable = new double[n];
            this.sintable = new double[n];
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                this.costable[n2] = Math.cos(d2);
                this.sintable[n2] = MathUtil.cosToSin(d2, this.costable[n2]);
                ++n2;
                d2 += d;
            }
        }

        @Override
        public double cos(int n) {
            n = Math.abs(n) % this.steps;
            return this.costable[n];
        }

        @Override
        public double sin(int n) {
            if ((n %= this.steps) < 0) {
                n += this.steps;
            }
            return this.sintable[n];
        }
    }
}

