/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.dependence;

import de.lmu.ifi.dbs.elki.math.statistics.dependence.SlopeDependenceMeasure;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="Elke Achtert, Hans-Peter Kriegel, Erich Schubert, Arthur Zimek", title="Interactive Data Mining with 3D-Parallel-Coordinate-Trees", booktitle="Proc. of the 2013 ACM International Conference on Management of Data (SIGMOD)", url="http://dx.doi.org/10.1145/2463676.2463696")
public class SlopeInversionDependenceMeasure
extends SlopeDependenceMeasure {
    public static final SlopeInversionDependenceMeasure STATIC = new SlopeInversionDependenceMeasure();

    protected SlopeInversionDependenceMeasure() {
    }

    @Override
    public <A, B> double dependence(NumberArrayAdapter<?, A> numberArrayAdapter, A a, NumberArrayAdapter<?, B> numberArrayAdapter2, B b) {
        double d;
        double d2;
        int n;
        double d3;
        int n2 = SlopeInversionDependenceMeasure.size(numberArrayAdapter, a, numberArrayAdapter2, b);
        double d4 = d3 = numberArrayAdapter.getDouble(a, 0);
        for (n = 1; n < n2; ++n) {
            d2 = numberArrayAdapter.getDouble(a, n);
            if (d2 < d3) {
                d3 = d2;
                continue;
            }
            if (!(d2 > d4)) continue;
            d4 = d2;
        }
        double d5 = d3;
        double d6 = d4 > d3 ? 1.0 / (d4 - d3) : 1.0;
        d4 = d3 = numberArrayAdapter2.getDouble(b, 0);
        for (n = 1; n < n2; ++n) {
            d2 = numberArrayAdapter2.getDouble(b, n);
            if (d2 < d3) {
                d3 = d2;
                continue;
            }
            if (!(d2 > d4)) continue;
            d4 = d2;
        }
        double d7 = d3;
        double d8 = d4 > d3 ? 1.0 / (d4 - d3) : 1.0;
        int[] nArray = new int[40];
        int[] nArray2 = new int[40];
        for (int i = 0; i < n2; ++i) {
            double d9 = numberArrayAdapter.getDouble(a, i);
            d2 = numberArrayAdapter2.getDouble(b, i);
            d = (d9 = (d9 - d5) * d6) - (d2 = (d2 - d7) * d8) + 1.0;
            int n3 = (int)Math.round(d * 20.0);
            int n4 = n3 = n3 < 0 ? 0 : (n3 >= 40 ? 39 : n3);
            nArray[n4] = nArray[n4] + 1;
            d = d9 + d2;
            n3 = (int)Math.round(d * 20.0);
            int n5 = n3 = n3 < 0 ? 0 : (n3 >= 40 ? 39 : n3);
            nArray2[n5] = nArray2[n5] + 1;
        }
        double d10 = 0.0;
        double d11 = 0.0;
        for (int i = 0; i < 40; ++i) {
            if (nArray[i] > 0) {
                d = (double)nArray[i] / (double)n2;
                d10 += d * Math.log(d);
            }
            if (nArray2[i] <= 0) continue;
            d = (double)nArray2[i] / (double)n2;
            d11 += d * Math.log(d);
        }
        if (d10 >= d11) {
            return 1.0 + d10 / LOG_PRECISION;
        }
        return 1.0 + d11 / LOG_PRECISION;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SlopeInversionDependenceMeasure makeInstance() {
            return STATIC;
        }
    }
}

