/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.WeibullDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class WeibullLogMOMEstimator
implements DistributionEstimator<WeibullDistribution> {
    public static final WeibullLogMOMEstimator STATIC = new WeibullLogMOMEstimator();

    private WeibullLogMOMEstimator() {
    }

    @Override
    public <A> WeibullDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        double d = 0.0;
        double d2 = 0.0;
        MeanVariance meanVariance = new MeanVariance();
        int n = numberArrayAdapter.size(a);
        double d3 = (double)n + 1.0;
        for (int i = 0; i < n; ++i) {
            double d4 = numberArrayAdapter.getDouble(a, i);
            if (!(d4 > 0.0)) {
                throw new ArithmeticException("Cannot least squares fit weibull to a data set which includes non-positive values: " + d4);
            }
            double d5 = Math.log(-Math.log((double)(n - i) / d3));
            double d6 = Math.log(d4);
            d += d5 * d6;
            d2 += d5;
            meanVariance.put(d6);
        }
        double d7 = (d / (double)n - d2 / (double)n * meanVariance.getMean()) / meanVariance.getSampleVariance();
        double d8 = 1.0 / Math.exp(d2 / (double)n - d7 * meanVariance.getMean());
        return new WeibullDistribution(d7, d8);
    }

    @Override
    public Class<? super WeibullDistribution> getDistributionClass() {
        return WeibullDistribution.class;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected WeibullLogMOMEstimator makeInstance() {
            return STATIC;
        }
    }
}

