/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.result.textwriter.TextWriterWriterInterface;
import de.lmu.ifi.dbs.elki.result.textwriter.writers.TextWriterObjectComment;
import de.lmu.ifi.dbs.elki.utilities.HandlerList;
import java.io.PrintStream;

public class TextWriterStream {
    private PrintStream outStream;
    private StringBuilder inline;
    private StringBuilder comment;
    private HandlerList<TextWriterWriterInterface<?>> writers;
    public static final String SEPARATOR = " ";
    public static final String QUOTE = "# ";
    public static final String COMMENTSEP = "###############################################################";
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String SER_MARKER = "Serialization class:";
    private boolean forceincomments = false;
    private TextWriterObjectComment fallbackwriter = new TextWriterObjectComment();

    public TextWriterStream(PrintStream printStream, HandlerList<TextWriterWriterInterface<?>> handlerList) {
        this.outStream = printStream;
        this.writers = handlerList;
        this.inline = new StringBuilder();
        this.comment = new StringBuilder();
    }

    public void commentPrint(Object object) {
        this.comment.append(object);
    }

    public void commentPrintLn(Object object) {
        this.comment.append(object);
        this.comment.append(NEWLINE);
    }

    public void commentPrintLn() {
        this.comment.append(NEWLINE);
    }

    public void commentPrintSeparator() {
        this.comment.append(COMMENTSEP + NEWLINE);
    }

    public void inlinePrint(Object object) {
        if (this.forceincomments) {
            this.commentPrint(object);
            return;
        }
        if (this.inline.length() > 0) {
            this.inline.append(SEPARATOR);
        }
        String string = object.toString().replace(NEWLINE, SEPARATOR);
        if ((string = string.replace("\\", "\\\\").replace("\"", "\\\"")).contains(SEPARATOR)) {
            string = "\"" + string + "\"";
        }
        this.inline.append(string);
    }

    public void inlinePrintNoQuotes(Object object) {
        if (this.forceincomments) {
            this.commentPrint(object);
            return;
        }
        if (this.inline.length() > 0) {
            this.inline.append(SEPARATOR);
        }
        String string = object.toString().replace(NEWLINE, SEPARATOR);
        string = string.replace("\\", "\\\\").replace("\"", "\\\"");
        this.inline.append(string);
    }

    public void flush() {
        if (this.inline.length() > 0) {
            this.outStream.println(this.inline);
        }
        this.inline.setLength(0);
        if (this.comment.length() > 0) {
            this.quotePrintln(this.outStream, this.comment.toString());
        }
        this.comment.setLength(0);
    }

    private void quotePrintln(PrintStream printStream, String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\r\n|\r|\n")) {
            if (string2.equals(COMMENTSEP)) {
                printStream.println(COMMENTSEP);
                continue;
            }
            printStream.println(QUOTE + string2);
        }
    }

    public TextWriterWriterInterface<?> getWriterFor(Object object) {
        if (object == null) {
            return null;
        }
        TextWriterWriterInterface<?> textWriterWriterInterface = this.writers.getHandler(object);
        if (textWriterWriterInterface == null) {
            try {
                if (object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class) {
                    return this.fallbackwriter;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return textWriterWriterInterface;
    }

    public <O> O normalizationRestore(O o) {
        return o;
    }

    protected boolean isForceincomments() {
        return this.forceincomments;
    }

    protected void setForceincomments(boolean bl) {
        this.forceincomments = bl;
    }
}

