/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projector;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.AffineTransformation;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.projections.AffineProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Simple2D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;
import de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj.LabelVisualization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ScatterPlotProjector<V extends SpatialComparable>
implements Projector {
    Relation<V> rel;
    int dmax;

    public ScatterPlotProjector(Relation<V> relation, int n) {
        this.rel = relation;
        this.dmax = n;
        assert (n <= RelationUtil.dimensionality(relation)) : "Requested dimensionality larger than data dimensionality?!?";
    }

    @Override
    public Collection<PlotItem> arrange(VisualizerContext visualizerContext) {
        ArrayList<PlotItem> arrayList = new ArrayList<PlotItem>(1);
        List<VisualizationTask> list = visualizerContext.getVisTasks(this);
        if (list.size() > 0) {
            PlotItem plotItem;
            ScalesResult scalesResult = ResultUtil.getScalesResult(this.rel);
            if (this.dmax == 2) {
                plotItem = new PlotItem(2.1, 2.1, null);
                Object object = new Simple2D(this, scalesResult.getScales(), 0, 1);
                Object object2 = new PlotItem(0.1, 0.0, 2.0, 2.0, (Projection)object);
                ((PlotItem)object2).tasks = list;
                plotItem.subitems.add((PlotItem)object2);
                object = new PlotItem(0.1, 2.0, 2.0, 0.1, null);
                object2 = new VisualizationTask("", visualizerContext, null, null, new LabelVisualization(RelationUtil.getColumnLabel(this.rel, 0)));
                ((VisualizationTask)object2).reqheight = 0.1;
                ((VisualizationTask)object2).reqwidth = 2.0;
                ((VisualizationTask)object2).addFlags(2);
                ((PlotItem)object).tasks.add((VisualizationTask)object2);
                plotItem.subitems.add((PlotItem)object);
                object = new PlotItem(0.0, 0.0, 0.1, 2.0, null);
                object2 = new VisualizationTask("", visualizerContext, null, null, new LabelVisualization(RelationUtil.getColumnLabel(this.rel, 1), true));
                ((VisualizationTask)object2).reqheight = 2.0;
                ((VisualizationTask)object2).reqwidth = 0.1;
                ((VisualizationTask)object2).addFlags(2);
                ((PlotItem)object).tasks.add((VisualizationTask)object2);
                plotItem.subitems.add((PlotItem)object);
            } else {
                Object object;
                int n;
                double d = Math.ceil((double)(this.dmax - 1) / 2.0);
                plotItem = new PlotItem(d * 2.0 + 0.1, (double)(this.dmax - 1) + 0.1, null);
                for (n = 0; n < this.dmax - 1; ++n) {
                    for (int i = n + 1; i < this.dmax; ++i) {
                        object = new Simple2D(this, scalesResult.getScales(), n, i);
                        PlotItem plotItem2 = new PlotItem((double)n + 0.1, i - 1, 1.0, 1.0, (Projection)object);
                        plotItem2.tasks = list;
                        plotItem.subitems.add(plotItem2);
                    }
                }
                if (this.dmax >= 3) {
                    AffineTransformation affineTransformation = AffineProjection.axisProjection(RelationUtil.dimensionality(this.rel), 1, 2);
                    affineTransformation.addRotation(0, 2, -0.17453292519943295);
                    affineTransformation.addRotation(1, 2, 0.2617993877991494);
                    AffineProjection affineProjection = new AffineProjection(this, scalesResult.getScales(), affineTransformation);
                    object = new PlotItem(d + 0.1, 0.0, d, d, affineProjection);
                    ((PlotItem)object).tasks = list;
                    plotItem.subitems.add((PlotItem)object);
                }
                for (n = 0; n < this.dmax - 1; ++n) {
                    PlotItem plotItem3 = new PlotItem((double)n + 0.1, this.dmax - 1, 1.0, 0.1, null);
                    object = new VisualizationTask("", visualizerContext, null, null, new LabelVisualization(RelationUtil.getColumnLabel(this.rel, n)));
                    ((VisualizationTask)object).reqheight = 0.1;
                    ((VisualizationTask)object).reqwidth = 1.0;
                    ((VisualizationTask)object).addFlags(2);
                    plotItem3.tasks.add((VisualizationTask)object);
                    plotItem.subitems.add(plotItem3);
                }
                for (n = 1; n < this.dmax; ++n) {
                    PlotItem plotItem4 = new PlotItem(0.0, n - 1, 0.1, 1.0, null);
                    object = new VisualizationTask("", visualizerContext, null, null, new LabelVisualization(RelationUtil.getColumnLabel(this.rel, n), true));
                    ((VisualizationTask)object).reqheight = 1.0;
                    ((VisualizationTask)object).reqwidth = 0.1;
                    ((VisualizationTask)object).addFlags(2);
                    plotItem4.tasks.add((VisualizationTask)object);
                    plotItem.subitems.add(plotItem4);
                }
            }
            arrayList.add(plotItem);
        }
        return arrayList;
    }

    @Override
    public String getMenuName() {
        return "Scatterplot";
    }

    public Relation<V> getRelation() {
        return this.rel;
    }
}

