/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.wfg;

import java.util.ArrayList;
import java.util.Random;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.DefaultDoubleSolution;

public abstract class WFG
extends AbstractDoubleProblem {
    private final float epsilon = 1.0E-7f;
    protected int k;
    protected int m;
    protected int l;
    protected int[] a;
    protected int[] s;
    protected int d = 1;
    protected Random random = new Random();

    public WFG(Integer k, Integer l, Integer M) {
        this.k = k;
        this.l = l;
        this.m = M;
        this.setNumberOfVariables(this.k + this.l);
        this.setNumberOfObjectives(this.m);
        this.setNumberOfConstraints(0);
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(2.0 * (double)(i + 1));
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public DoubleSolution createSolution() {
        return new DefaultDoubleSolution(this);
    }

    public float[] calculateX(float[] t) {
        float[] x = new float[this.m];
        for (int i = 0; i < this.m - 1; ++i) {
            x[i] = Math.max(t[this.m - 1], (float)this.a[i]) * (t[i] - 0.5f) + 0.5f;
        }
        x[this.m - 1] = t[this.m - 1];
        return x;
    }

    public float[] normalise(float[] z) {
        float[] result = new float[z.length];
        for (int i = 0; i < z.length; ++i) {
            float bound = 2.0f * (float)(i + 1);
            result[i] = z[i] / bound;
            result[i] = this.correctTo01(result[i]);
        }
        return result;
    }

    public float correctTo01(float a) {
        float min = 0.0f;
        float max = 1.0f;
        float minEpsilon = min - 1.0E-7f;
        float maxEpsilon = max + 1.0E-7f;
        if (a <= min && a >= minEpsilon || a >= min && a <= minEpsilon) {
            return min;
        }
        if (a >= max && a <= maxEpsilon || a <= max && a >= maxEpsilon) {
            return max;
        }
        return a;
    }

    public float[] subVector(float[] z, int head, int tail) {
        int size = tail - head + 1;
        float[] result = new float[size];
        System.arraycopy(z, head, result, head - head, tail + 1 - head);
        return result;
    }

    public abstract float[] evaluate(float[] var1);
}

