/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.engine.traceability.fine;

import org.eclipse.epsilon.egl.engine.traceability.fine.internal.EglOutputBufferPrintExecutionListener;
import org.eclipse.epsilon.egl.engine.traceability.fine.internal.TraceLinkCreatingTemplateExecutionListener;
import org.eclipse.epsilon.egl.engine.traceability.fine.internal.TracedPropertyAccessLedger;
import org.eclipse.epsilon.egl.engine.traceability.fine.trace.Trace;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.eol.execute.introspection.recording.PropertyAccessExecutionListener;
import org.eclipse.epsilon.eol.execute.introspection.recording.PropertyAccessRecorder;

public class EglFineGrainedTraceContextAdaptor {
    public Trace adapt(IEglContext context) {
        Trace trace = new Trace();
        TracedPropertyAccessLedger ledger = new TracedPropertyAccessLedger();
        this.selectivelyRecordPropertyAccesses(context, ledger);
        this.listenForTemplateExecution(context, trace, ledger);
        return trace;
    }

    protected void listenForTemplateExecution(IEglContext context, Trace trace, TracedPropertyAccessLedger ledger) {
        context.getTemplateFactory().getTemplateExecutionListeners().add(new TraceLinkCreatingTemplateExecutionListener(trace, ledger));
    }

    protected void selectivelyRecordPropertyAccesses(IEglContext context, TracedPropertyAccessLedger ledger) {
        PropertyAccessRecorder recorder = new PropertyAccessRecorder();
        context.getExecutorFactory().addExecutionListener(new PropertyAccessExecutionListener(recorder));
        context.getExecutorFactory().addExecutionListener(new EglOutputBufferPrintExecutionListener(recorder, ledger));
    }
}

