/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.csv;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.common.util.FileUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.csv.CsvPropertyGetter;
import org.eclipse.epsilon.emc.csv.CsvPropertySetter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IReflectivePropertySetter;
import org.eclipse.epsilon.eol.models.CachedModel;

public class CsvModel
extends CachedModel<Map<String, Object>> {
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_FIELD_SEPARATOR = "fieldSeparator";
    public static final String PROPERTY_HAS_KNOWN_HEADERS = "hasKNownHeaders";
    public static final String PROPERTY_HAS_VARARGS_HEADERS = "hasVarargsHeaders";
    private String fieldSeparator = ",";
    private boolean knownHeaders;
    private boolean varargsHeaders;
    private String file;
    private Collection<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public boolean isKnownHeaders() {
        return this.knownHeaders;
    }

    public void setKnownHeaders(boolean knownHeaders) {
        this.knownHeaders = knownHeaders;
    }

    public boolean isVarargsHeaders() {
        return this.varargsHeaders;
    }

    public void setVarargsHeaders(boolean varargsHeaders) {
        this.varargsHeaders = varargsHeaders;
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getTypeOf(Object instance) {
        return LinkedHashMap.class;
    }

    @Override
    public String getTypeNameOf(Object instance) {
        return LinkedHashMap.class.getName();
    }

    @Override
    public Object getElementById(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getElementId(Object instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setElementId(Object instance, String newId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean owns(Object instance) {
        return this.rows.contains(instance);
    }

    @Override
    public boolean isInstantiable(String type) {
        return false;
    }

    @Override
    public boolean isModelElement(Object instance) {
        return instance instanceof LinkedHashMap;
    }

    @Override
    public boolean hasType(String type) {
        return "Row".equals(type);
    }

    @Override
    public boolean store(String location) {
        try {
            FileUtil.setFileContents(this.concatenateMap(), new File(location));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean store() {
        try {
            FileUtil.setFileContents(this.concatenateMap(), new File(this.file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String concatenateMap() {
        StringBuilder output = new StringBuilder();
        if (this.knownHeaders) {
            Iterator keyIt = ((Map)((LinkedList)this.rows).getFirst()).keySet().iterator();
            output.append((String)keyIt.next());
            while (keyIt.hasNext()) {
                output.append(this.fieldSeparator);
                output.append((String)keyIt.next());
            }
            output.append(System.getProperty("line.separator"));
        }
        for (Map<String, Object> row : this.rows) {
            Iterator<Object> fieldIt = row.values().iterator();
            output.append(fieldIt.next());
            while (fieldIt.hasNext()) {
                output.append(this.fieldSeparator);
                output.append(fieldIt.next());
            }
            output.append(System.getProperty("line.separator"));
        }
        return output.toString();
    }

    @Override
    protected Collection<? extends Map<String, Object>> allContentsFromModel() {
        return this.rows;
    }

    @Override
    protected Collection<? extends Map<String, Object>> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        if (!"Row".equals(type)) {
            throw new EolModelElementTypeNotFoundException(this.name, type);
        }
        return this.allContents();
    }

    @Override
    protected Collection<? extends Map<String, Object>> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        if (!"Row".equals(kind)) {
            throw new EolModelElementTypeNotFoundException(this.name, kind);
        }
        return this.allContents();
    }

    @Override
    protected Map<String, Object> createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (!"Row".equals(type)) {
            throw new EolModelElementTypeNotFoundException(this.name, type);
        }
        LinkedHashMap<String, Object> returnVal = new LinkedHashMap<String, Object>();
        for (String key : ((Map)((LinkedList)this.rows).getFirst()).keySet()) {
            returnVal.put(key, "");
        }
        this.rows.add(returnVal);
        return returnVal;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new CsvPropertyGetter();
    }

    @Override
    public IReflectivePropertySetter getPropertySetter() {
        return new CsvPropertySetter();
    }

    public boolean hasProperty(String type, String property) throws EolModelElementTypeNotFoundException {
        if (!this.hasType(type)) {
            throw new EolModelElementTypeNotFoundException(this.name, type);
        }
        if (!this.knownHeaders) {
            return true;
        }
        if (this.varargsHeaders) {
            if (((LinkedHashMap)((LinkedList)this.rows).getFirst()).keySet().contains(property)) {
                return true;
            }
            String varargsHeader = (String)((LinkedHashMap)((LinkedList)this.rows).getFirst()).keySet().iterator().next();
            return varargsHeader.startsWith(property);
        }
        return ((LinkedHashMap)((LinkedList)this.rows).getFirst()).keySet().contains(property);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void loadModel() throws EolModelLoadingException {
        block24: {
            block26: {
                block25: {
                    lines = null;
                    try {
                        try {
                            lines = new LinkedList<String>(FileUtil.getFileLineContents(new File(this.file)));
                            break block24;
                        }
                        catch (Exception ex) {
                            throw new EolModelLoadingException(ex, this);
                        }
                    }
                    catch (Throwable var3_3) {
                        if (!this.knownHeaders) break block25;
                        keys = Arrays.asList(((String)lines.get(0)).split(this.fieldSeparator));
                        i = 1;
                        ** while (i < lines.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        row = new LinkedHashMap<String, Object>();
                        values = Arrays.asList(lines.get(i).split(this.fieldSeparator));
                        if (!this.varargsHeaders) {
                            if (keys.size() != values.size()) {
                                ex = new Exception("Line " + (i + 1) + " contains different number of elements than the header");
                                throw new EolModelLoadingException(ex, this);
                            }
                            f = 0;
                            while (f < keys.size()) {
                                row.put(keys.get(f), values.get(f));
                                ++f;
                            }
                        } else {
                            if (keys.size() - 1 > values.size()) {
                                ex = new Exception("Line " + i + " contains different number of elements than the header");
                                throw new EolModelLoadingException(ex, this);
                            }
                            numKeys = keys.size();
                            varargHeader = keys.get(numKeys - 1);
                            f = 0;
                            while (f < numKeys - 1) {
                                row.put(keys.get(f), values.get(f));
                                ++f;
                            }
                            varargsField = new ArrayList<String>();
                            v = numKeys - 1;
                            while (v < values.size()) {
                                varargsField.add(values.get(v));
                                ++v;
                            }
                            row.put(varargHeader, varargsField);
                        }
                        this.rows.add(row);
                        ++i;
                        continue;
lbl50:
                        // 1 sources

                        break block26;
                    }
                }
                i = 0;
                while (i < lines.size()) {
                    row = new LinkedHashMap<String, List<String>>();
                    row.put("field", Arrays.asList(lines.get(i).split(this.fieldSeparator)));
                    this.rows.add(row);
                    ++i;
                }
            }
            throw var3_3;
        }
        if (this.knownHeaders) {
            keys = Arrays.asList(lines.get(0).split(this.fieldSeparator));
            i = 1;
            while (i < lines.size()) {
                row = new LinkedHashMap<String, Object>();
                values = Arrays.asList(lines.get(i).split(this.fieldSeparator));
                if (!this.varargsHeaders) {
                    if (keys.size() != values.size()) {
                        ex = new Exception("Line " + (i + 1) + " contains different number of elements than the header");
                        throw new EolModelLoadingException(ex, this);
                    }
                    f = 0;
                    while (f < keys.size()) {
                        row.put(keys.get(f), values.get(f));
                        ++f;
                    }
                } else {
                    if (keys.size() - 1 > values.size()) {
                        ex = new Exception("Line " + i + " contains different number of elements than the header");
                        throw new EolModelLoadingException(ex, this);
                    }
                    numKeys = keys.size();
                    varargHeader = keys.get(numKeys - 1);
                    f = 0;
                    while (f < numKeys - 1) {
                        row.put(keys.get(f), values.get(f));
                        ++f;
                    }
                    varargsField = new ArrayList<String>();
                    v = numKeys - 1;
                    while (v < values.size()) {
                        varargsField.add(values.get(v));
                        ++v;
                    }
                    row.put(varargHeader, varargsField);
                }
                this.rows.add(row);
                ++i;
            }
        } else {
            i = 0;
            while (i < lines.size()) {
                row = new LinkedHashMap<String, List<String>>();
                row.put("field", Arrays.asList(lines.get(i).split(this.fieldSeparator)));
                this.rows.add(row);
                ++i;
            }
        }
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        super.load(properties, basePath);
        this.file = basePath != null ? String.valueOf(basePath) + properties.getProperty(PROPERTY_FILE) : properties.getProperty(PROPERTY_FILE);
        this.fieldSeparator = properties.getProperty(PROPERTY_FIELD_SEPARATOR);
        this.knownHeaders = properties.getBooleanProperty(PROPERTY_HAS_KNOWN_HEADERS, true);
        this.varargsHeaders = properties.getBooleanProperty(PROPERTY_HAS_VARARGS_HEADERS, false);
        this.load();
    }

    @Override
    protected void disposeModel() {
        this.rows.clear();
    }

    @Override
    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        return this.rows.remove(instance);
    }

    @Override
    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    @Override
    protected Collection<String> getAllTypeNamesOf(Object instance) {
        return Collections.singleton("Row");
    }
}

