/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class NominalToBinary
extends Filter
implements UnsupervisedFilter,
OptionHandler,
StreamableFilter {
    static final long serialVersionUID = -1130642825710549138L;
    protected Range m_Columns = new Range();
    private boolean m_Numeric = true;
    private boolean m_TransformAll = false;
    private boolean m_needToTransform = false;

    public NominalToBinary() {
        this.setAttributeIndices("first-last");
    }

    public String globalInfo() {
        return "Converts all nominal attributes into binary numeric attributes. An attribute with k values is transformed into k binary attributes if the class is nominal (using the one-attribute-per-value approach). Binary attributes are left binary, if option '-A' is not given.If the class is numeric, you might want to use the supervised version of this filter.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_Columns.setUpper(instanceInfo.numAttributes() - 1);
        this.setOutputFormat();
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tSets if binary attributes are to be coded as nominal ones.", "N", 0, "-N"));
        newVector.addElement(new Option("\tFor each nominal value a new attribute is created, \n\tnot only if there are more than 2 values.", "A", 0, "-A"));
        newVector.addElement(new Option("\tSpecifies list of columns to act on. First and last are \n\tvalid indexes.\n\t(default: first-last)", "R", 1, "-R <col1,col2-col4,...>"));
        newVector.addElement(new Option("\tInvert matching sense of column indexes.", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setBinaryAttributesNominal(Utils.getFlag('N', options));
        this.setTransformAllValues(Utils.getFlag('A', options));
        String convertList = Utils.getOption('R', options);
        if (convertList.length() != 0) {
            this.setAttributeIndices(convertList);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getBinaryAttributesNominal()) {
            options.add("-N");
        }
        if (this.getTransformAllValues()) {
            options.add("-A");
        }
        if (!this.getAttributeIndices().equals("")) {
            options.add("-R");
            options.add(this.getAttributeIndices());
        }
        if (this.getInvertSelection()) {
            options.add("-V");
        }
        return options.toArray(new String[0]);
    }

    public String binaryAttributesNominalTipText() {
        return "Whether resulting binary attributes will be nominal.";
    }

    public boolean getBinaryAttributesNominal() {
        return !this.m_Numeric;
    }

    public void setBinaryAttributesNominal(boolean bool) {
        this.m_Numeric = !bool;
    }

    public String transformAllValuesTipText() {
        return "Whether all nominal values are turned into new attributes, not only if there are more than 2.";
    }

    public boolean getTransformAllValues() {
        return this.m_TransformAll;
    }

    public void setTransformAllValues(boolean bool) {
        this.m_TransformAll = bool;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected (numeric) attributes in the range will be discretized; if true, only non-selected attributes will be discretized.";
    }

    public boolean getInvertSelection() {
        return this.m_Columns.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_Columns.setInvert(invert);
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getAttributeIndices() {
        return this.m_Columns.getRanges();
    }

    public void setAttributeIndices(String rangeList) {
        this.m_Columns.setRanges(rangeList);
    }

    private void setOutputFormat() {
        Attribute att;
        this.m_needToTransform = false;
        int i = 0;
        while (i < this.getInputFormat().numAttributes()) {
            att = this.getInputFormat().attribute(i);
            if (att.isNominal() && i != this.getInputFormat().classIndex() && (att.numValues() > 2 || this.m_TransformAll || this.m_Numeric)) {
                this.m_needToTransform = true;
                break;
            }
            ++i;
        }
        if (!this.m_needToTransform) {
            this.setOutputFormat(this.getInputFormat());
            return;
        }
        int newClassIndex = this.getInputFormat().classIndex();
        ArrayList<Attribute> newAtts = new ArrayList<Attribute>();
        int j = 0;
        while (j < this.getInputFormat().numAttributes()) {
            att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex() || !this.m_Columns.isInRange(j)) {
                newAtts.add((Attribute)att.copy());
            } else if (att.numValues() <= 2 && !this.m_TransformAll) {
                if (this.m_Numeric) {
                    newAtts.add(new Attribute(att.name()));
                } else {
                    newAtts.add((Attribute)att.copy());
                }
            } else {
                if (newClassIndex >= 0 && j < this.getInputFormat().classIndex()) {
                    newClassIndex += att.numValues() - 1;
                }
                int k = 0;
                while (k < att.numValues()) {
                    StringBuffer attributeName = new StringBuffer(String.valueOf(att.name()) + "=");
                    attributeName.append(att.value(k));
                    if (this.m_Numeric) {
                        newAtts.add(new Attribute(attributeName.toString()));
                    } else {
                        ArrayList<String> vals = new ArrayList<String>(2);
                        vals.add("f");
                        vals.add("t");
                        newAtts.add(new Attribute(attributeName.toString(), vals));
                    }
                    ++k;
                }
            }
            ++j;
        }
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        outputFormat.setClassIndex(newClassIndex);
        this.setOutputFormat(outputFormat);
    }

    private void convertInstance(Instance instance) {
        if (!this.m_needToTransform) {
            this.push(instance);
            return;
        }
        double[] vals = new double[this.outputFormatPeek().numAttributes()];
        int attSoFar = 0;
        int j = 0;
        while (j < this.getInputFormat().numAttributes()) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || j == this.getInputFormat().classIndex() || !this.m_Columns.isInRange(j)) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
            } else if (att.numValues() <= 2 && !this.m_TransformAll) {
                vals[attSoFar] = instance.value(j);
                ++attSoFar;
            } else {
                int k;
                if (instance.isMissing(j)) {
                    k = 0;
                    while (k < att.numValues()) {
                        vals[attSoFar + k] = instance.value(j);
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < att.numValues()) {
                        vals[attSoFar + k] = k == (int)instance.value(j) ? 1.0 : 0.0;
                        ++k;
                    }
                }
                attSoFar += att.numValues();
            }
            ++j;
        }
        AbstractInstance inst = null;
        inst = instance instanceof SparseInstance ? new SparseInstance(instance.weight(), vals) : new DenseInstance(instance.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, instance.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        this.push(inst);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10215 $");
    }

    public static void main(String[] argv) {
        NominalToBinary.runFilter(new NominalToBinary(), argv);
    }
}

