/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithmUtil;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMedoidsPAM;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Random;

@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Clustering Large Data Sets (with discussion)", booktitle="Pattern Recognition in Practice II")
public class CLARA<V>
extends KMedoidsPAM<V> {
    private static final Logging LOG = Logging.getLogger(CLARA.class);
    double sampling;
    int numsamples;
    RandomFactory random;

    public CLARA(DistanceFunction<? super V> distanceFunction, int n, int n2, KMedoidsInitialization<V> kMedoidsInitialization, int n3, double d, RandomFactory randomFactory) {
        super(distanceFunction, n, n2, kMedoidsInitialization);
        this.numsamples = n3;
        this.sampling = d;
        this.random = randomFactory;
    }

    @Override
    public Clustering<MedoidModel> run(Database database, Relation<V> relation) {
        Object object;
        Object object2;
        Object object3;
        if (relation.size() <= 0) {
            return new Clustering<MedoidModel>("CLARA Clustering", "clara-clustering");
        }
        DBIDs dBIDs = relation.getDBIDs();
        DistanceQuery<V> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        double d = Double.POSITIVE_INFINITY;
        Object object4 = null;
        Object object5 = null;
        Random random = this.random.getSingleThreadedRandom();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Processing random samples", this.numsamples, LOG) : null;
        for (int i = 0; i < this.numsamples; ++i) {
            object3 = DBIDUtil.randomSample(dBIDs, this.sampling, random);
            object2 = DBIDUtil.newArray(this.initializer.chooseInitialMedoids(this.k, (DBIDs)object3, distanceQuery));
            object = DataStoreUtil.makeIntegerStorage(dBIDs, 3, -1);
            this.runPAMOptimization(distanceQuery, (DBIDs)object3, (ArrayModifiableDBIDs)object2, (WritableIntegerDataStore)object);
            double d2 = this.assignRemainingToNearestCluster((ArrayDBIDs)object2, dBIDs, (DBIDs)object3, (WritableIntegerDataStore)object, distanceQuery);
            if (d2 < d) {
                d = d2;
                object4 = object2;
                object5 = object;
            }
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.ensureCompleted(finiteProgress);
        ArrayModifiableDBIDs[] arrayModifiableDBIDsArray = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(dBIDs, object5, this.k);
        object3 = new Clustering("CLARA Clustering", "clara-clustering");
        object2 = object4.iter();
        while (object2.valid()) {
            object = new MedoidModel(DBIDUtil.deref((DBIDRef)object2));
            ((Clustering)object3).addToplevelCluster(new Cluster<Object>((DBIDs)arrayModifiableDBIDsArray[object2.getOffset()], object));
            object2.advance();
        }
        return object3;
    }

    protected double assignRemainingToNearestCluster(ArrayDBIDs arrayDBIDs, DBIDs dBIDs, DBIDs dBIDs2, WritableIntegerDataStore writableIntegerDataStore, DistanceQuery<V> distanceQuery) {
        dBIDs2 = DBIDUtil.ensureSet(dBIDs2);
        double d = 0.0;
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDIter dBIDIter = distanceQuery.getRelation().iterDBIDs();
        while (dBIDIter.valid()) {
            if (!dBIDs2.contains(dBIDIter)) {
                double d2 = Double.POSITIVE_INFINITY;
                int n = 0;
                dBIDArrayIter.seek(0);
                int n2 = 0;
                while (dBIDArrayIter.valid()) {
                    double d3 = distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDArrayIter);
                    if (d3 < d2) {
                        n = n2;
                        d2 = d3;
                    }
                    dBIDArrayIter.advance();
                    ++n2;
                }
                d += d2;
                writableIntegerDataStore.put((DBIDRef)dBIDIter, n);
            }
            dBIDIter.advance();
        }
        return d;
    }

    public static class Parameterizer<V>
    extends KMedoidsPAM.Parameterizer<V> {
        public static final OptionID NUMSAMPLES_ID = new OptionID("clara.samples", "Number of samples (iterations) to run.");
        public static final OptionID SAMPLESIZE_ID = new OptionID("clara.samplesize", "The size of the sample.");
        public static final OptionID RANDOM_ID = new OptionID("clara.random", "Random generator seed.");
        double sampling;
        int numsamples;
        RandomFactory random;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(NUMSAMPLES_ID, 5).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.numsamples = intParameter.intValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(SAMPLESIZE_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.sampling = doubleParameter.doubleValue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                this.random = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected CLARA<V> makeInstance() {
            return new CLARA(this.distanceFunction, this.k, this.maxiter, this.initializer, this.numsamples, this.sampling, this.random);
        }
    }
}

