/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import java.util.ArrayList;

public class RescaleMetaOutlierAlgorithm
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(RescaleMetaOutlierAlgorithm.class);
    public static final OptionID SCALING_ID = new OptionID("metaoutlier.scaling", "Class to use as scaling function.");
    private Algorithm algorithm;
    private ScalingFunction scaling;

    public RescaleMetaOutlierAlgorithm(Algorithm algorithm, ScalingFunction scalingFunction) {
        this.algorithm = algorithm;
        this.scaling = scalingFunction;
    }

    @Override
    public OutlierResult run(Database database) {
        Result result = this.algorithm.run(database);
        OutlierResult outlierResult = this.getOutlierResult(database.getHierarchy(), result);
        DoubleRelation doubleRelation = outlierResult.getScores();
        if (this.scaling instanceof OutlierScalingFunction) {
            ((OutlierScalingFunction)this.scaling).prepare(outlierResult);
        }
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(doubleRelation.getDBIDs(), 6);
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        Object object = doubleRelation.iterDBIDs();
        while (object.valid()) {
            double d = this.scaling.getScaled(doubleRelation.doubleValue((DBIDRef)object));
            writableDoubleDataStore.putDouble((DBIDRef)object, d);
            doubleMinMax.put(d);
            object.advance();
        }
        object = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), this.scaling.getMin(), this.scaling.getMax());
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("Scaled Outlier", "scaled-outlier", writableDoubleDataStore, doubleRelation.getDBIDs());
        OutlierResult outlierResult2 = new OutlierResult((OutlierScoreMeta)object, materializedDoubleRelation);
        outlierResult2.addChildResult(result);
        return outlierResult2;
    }

    private OutlierResult getOutlierResult(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<OutlierResult> arrayList = ResultUtil.filterResults(resultHierarchy, result, OutlierResult.class);
        if (arrayList.size() > 0) {
            return (OutlierResult)arrayList.get(0);
        }
        throw new IllegalStateException("Comparison algorithm expected at least one outlier result.");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private Algorithm algorithm;
        private ScalingFunction scaling;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter2 = new ObjectParameter(AlgorithmStep.Parameterizer.ALGORITHM_ID, OutlierAlgorithm.class);
            if (parameterization.grab(objectParameter2)) {
                this.algorithm = (Algorithm)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, ScalingFunction.class))) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected RescaleMetaOutlierAlgorithm makeInstance() {
            return new RescaleMetaOutlierAlgorithm(this.algorithm, this.scaling);
        }
    }
}

