/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.AbstractEditDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.timeseries.DTWDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Arrays;

@Title(value="Edit Distance with Real Penalty")
@Reference(authors="L. Chen and R. Ng", title="On the marriage of Lp-norms and edit distance", booktitle="VLDB '04: Proceedings of the Thirtieth international conference on Very large data bases", url="http://www.vldb.org/conf/2004/RS21P2.PDF")
public class ERPDistanceFunction
extends DTWDistanceFunction {
    private final double g;

    public ERPDistanceFunction(double d, double d2) {
        super(d);
        this.g = d2;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = numberVector.getDimensionality();
        int n2 = numberVector2.getDimensionality();
        int n3 = n2 - 1;
        int n4 = this.effectiveBandSize(n, n2);
        if (Math.abs(n - n2) > n4) {
            return Double.POSITIVE_INFINITY;
        }
        double[] dArray = new double[n2 << 1];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        this.firstRow(dArray, n4, numberVector, numberVector2, n2);
        int n5 = 0;
        int n6 = n2;
        int n7 = 1;
        int n8 = 0;
        int n9 = Math.min(n3, n7 + n4);
        while (n7 < n) {
            double d = numberVector.doubleValue(n7);
            for (int i = n8; i <= n9; ++i) {
                double d2 = dArray[n5 + i] + this.delta(d, this.g);
                if (i > 0) {
                    double d3 = dArray[n5 + i - 1] + this.delta(d, numberVector2.doubleValue(i));
                    double d4 = d2 = d3 < d2 ? d3 : d2;
                    if (i > n8) {
                        double d5 = dArray[n6 + i - 1] + this.delta(this.g, numberVector2.doubleValue(i));
                        d2 = d5 < d2 ? d5 : d2;
                    }
                }
                dArray[n6 + i] = d2;
            }
            n5 = n2 - n5;
            n6 = n2 - n6;
            if (++n7 > n4) {
                ++n8;
            }
            if (n9 >= n3) continue;
            ++n9;
        }
        return Math.sqrt(dArray[n5 + n2 - 1]);
    }

    @Override
    protected void firstRow(double[] dArray, int n, NumberVector numberVector, NumberVector numberVector2, int n2) {
        double d = numberVector.doubleValue(0);
        dArray[0] = Math.min(this.delta(d, this.g), this.delta(d, numberVector2.doubleValue(0)));
        int n3 = n >= n2 ? n2 - 1 : n;
        for (int i = 1; i <= n3; ++i) {
            dArray[i] = Math.min(this.delta(d, this.g), dArray[i - 1]) + this.delta(d, numberVector2.doubleValue(i));
        }
    }

    @Override
    protected double delta(double d, double d2) {
        double d3 = d - d2;
        return d3 * d3;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return this.g == ((ERPDistanceFunction)object).g;
    }

    public static class Parameterizer
    extends AbstractEditDistanceFunction.Parameterizer {
        public static final OptionID G_ID = new OptionID("erp.g", "The g parameter of ERP - comparison value to use in gaps.");
        protected double g = 0.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(G_ID, 0.0);
            if (parameterization.grab(doubleParameter)) {
                this.g = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ERPDistanceFunction makeInstance() {
            return new ERPDistanceFunction(this.bandSize, this.g);
        }
    }
}

