/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;

public class MultipleLinearRegression {
    private final Vector y;
    private final double y_mean;
    private final Matrix x;
    private final Vector b;
    private final Vector e;
    private final double variance;
    private final Matrix xx_inverse;
    private final double ssr;
    private final double sst;

    public MultipleLinearRegression(Vector vector, Matrix matrix) {
        int n;
        if (vector.getDimensionality() <= matrix.getColumnDimensionality()) {
            throw new IllegalArgumentException("Number of observed data has to be greater than number of regressors: " + vector.getDimensionality() + " > " + matrix.getColumnDimensionality());
        }
        this.y = vector;
        this.x = matrix;
        double d = 0.0;
        for (n = 0; n < vector.getDimensionality(); ++n) {
            d += vector.get(n);
        }
        this.y_mean = d / (double)vector.getDimensionality();
        this.xx_inverse = matrix.transposeTimes(matrix).inverse();
        this.b = this.xx_inverse.timesTranspose(matrix).times(vector);
        this.e = vector.minus(matrix.times(this.b));
        d = 0.0;
        for (n = 0; n < this.e.getDimensionality(); ++n) {
            d += this.e.get(n) * this.e.get(n);
        }
        this.ssr = d;
        d = 0.0;
        for (n = 0; n < vector.getDimensionality(); ++n) {
            double d2 = vector.get(n) - this.y_mean;
            d += d2 * d2;
        }
        this.sst = d;
        this.variance = this.ssr / (double)(vector.getDimensionality() - matrix.getColumnDimensionality() - 1);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("x = ").append(FormatUtil.format(this.x, 9, 4));
        stringBuilder.append("\ny = ").append(FormatUtil.format(this.y, 9, 4));
        stringBuilder.append("\nb = ").append(FormatUtil.format(this.b, 9, 4));
        stringBuilder.append("\ne = ").append(FormatUtil.format(this.e, 9, 4));
        stringBuilder.append("error variance = ").append(FormatUtil.NF4.format(this.variance));
        return stringBuilder.toString();
    }

    public double getSumOfSquaresTotal() {
        return this.sst;
    }

    public double getSumOfSquareResiduals() {
        return this.ssr;
    }

    public Vector getEstimatedCoefficients() {
        return this.b;
    }

    public Vector getEstimatedResiduals() {
        return this.e;
    }

    public double coefficientOfDetermination() {
        return 1.0 - this.ssr / this.sst;
    }

    public double estimateY(Matrix matrix) {
        return matrix.times(this.b).get(0);
    }

    public double getVariance() {
        return this.variance;
    }
}

