/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentiallyModifiedGaussianDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMOMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. Olivier, M. M. Norberg", title="Positively skewed data: Revisiting the Box-Cox power transformation", booktitle="International Journal of Psychological Research Vol. 3 No. 1")
public class EMGOlivierNorbergEstimator
extends AbstractMOMEstimator<ExponentiallyModifiedGaussianDistribution> {
    public static EMGOlivierNorbergEstimator STATIC = new EMGOlivierNorbergEstimator();

    private EMGOlivierNorbergEstimator() {
    }

    @Override
    public ExponentiallyModifiedGaussianDistribution estimateFromStatisticalMoments(StatisticalMoments statisticalMoments) {
        double d = Math.pow(Math.max(0.0, statisticalMoments.getSampleSkewness() * 0.5), 0.3333333333333333);
        double d2 = statisticalMoments.getSampleStddev();
        double d3 = statisticalMoments.getMean() - d2 * d;
        double d4 = d2 * Math.sqrt(Math.abs((1.0 + d) * (1.0 - d)));
        double d5 = d > 0.0 ? 1.0 / (d2 * d) : 1.0;
        return new ExponentiallyModifiedGaussianDistribution(d3, d4, d5);
    }

    @Override
    public Class<? super ExponentiallyModifiedGaussianDistribution> getDistributionClass() {
        return ExponentiallyModifiedGaussianDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected EMGOlivierNorbergEstimator makeInstance() {
            return STATIC;
        }
    }
}

