/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.AbstractStoringPageFile;
import de.lmu.ifi.dbs.elki.persistent.Page;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public class MemoryPageFile<P extends Page>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(MemoryPageFile.class);
    private final TIntObjectMap<P> file = new TIntObjectHashMap<P>();

    public MemoryPageFile(int n) {
        super(n);
    }

    @Override
    public synchronized P readPage(int n) {
        this.countRead();
        return (P)((Page)this.file.get(n));
    }

    @Override
    protected void writePage(int n, P p) {
        this.countWrite();
        this.file.put(n, p);
        p.setDirty(false);
    }

    @Override
    public synchronized void deletePage(int n) {
        super.deletePage(n);
        this.countWrite();
        this.file.remove(n);
    }

    @Override
    public void clear() {
        this.file.clear();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

