/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result;

import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelOrAllInOneClustering;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import de.lmu.ifi.dbs.elki.result.IterableResult;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResultUtil {
    public static List<Relation<?>> getRelations(Result result) {
        if (result instanceof Relation) {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add((Relation)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return (List)ClassGenericsUtil.castWithGenericsOrNull(List.class, ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, Relation.class));
        }
        return Collections.emptyList();
    }

    public static List<OrderingResult> getOrderingResults(Result result) {
        if (result instanceof OrderingResult) {
            ArrayList<OrderingResult> arrayList = new ArrayList<OrderingResult>(1);
            arrayList.add((OrderingResult)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, OrderingResult.class);
        }
        return Collections.emptyList();
    }

    public static List<Clustering<? extends Model>> getClusteringResults(Result result) {
        if (result instanceof Clustering) {
            ArrayList<Clustering<? extends Model>> arrayList = new ArrayList<Clustering<? extends Model>>(1);
            arrayList.add((Clustering)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return (List)ClassGenericsUtil.castWithGenericsOrNull(List.class, ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, Clustering.class));
        }
        return Collections.emptyList();
    }

    public static List<CollectionResult<?>> getCollectionResults(Result result) {
        if (result instanceof CollectionResult) {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add((CollectionResult)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return (List)ClassGenericsUtil.castWithGenericsOrNull(List.class, ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, CollectionResult.class));
        }
        return Collections.emptyList();
    }

    public static List<IterableResult<?>> getIterableResults(Result result) {
        if (result instanceof IterableResult) {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add((IterableResult)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return (List)ClassGenericsUtil.castWithGenericsOrNull(List.class, ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, IterableResult.class));
        }
        return Collections.emptyList();
    }

    public static List<OutlierResult> getOutlierResults(Result result) {
        if (result instanceof OutlierResult) {
            ArrayList<OutlierResult> arrayList = new ArrayList<OutlierResult>(1);
            arrayList.add((OutlierResult)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, OutlierResult.class);
        }
        return Collections.emptyList();
    }

    public static List<SettingsResult> getSettingsResults(Result result) {
        if (result instanceof SettingsResult) {
            ArrayList<SettingsResult> arrayList = new ArrayList<SettingsResult>(1);
            arrayList.add((SettingsResult)result);
            return arrayList;
        }
        if (result instanceof HierarchicalResult) {
            return ResultUtil.filterResults(((HierarchicalResult)result).getHierarchy(), result, SettingsResult.class);
        }
        return Collections.emptyList();
    }

    public static <C extends Result> ArrayList<C> filterResults(ResultHierarchy resultHierarchy, Result result, Class<? super C> clazz) {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        if (clazz.isInstance(result)) {
            arrayList.add((Result)clazz.cast(result));
        }
        Hierarchy.Iter<Result> iter = resultHierarchy.iterDescendants(result);
        while (iter.valid()) {
            Result result2 = iter.get();
            if (clazz.isInstance(result2)) {
                arrayList.add((Result)clazz.cast(result2));
            }
            iter.advance();
        }
        return arrayList;
    }

    public static <C extends Result> ArrayList<C> filterResults(ResultHierarchy resultHierarchy, Class<? super C> clazz) {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        Hierarchy.Iter iter = resultHierarchy.iterAll();
        while (iter.valid()) {
            Result result = (Result)iter.get();
            if (clazz.isInstance(result)) {
                arrayList.add((Result)clazz.cast(result));
            }
            iter.advance();
        }
        return arrayList;
    }

    public static void ensureClusteringResult(Database database, Result result) {
        ArrayList<Clustering> arrayList = ResultUtil.filterResults(database.getHierarchy(), result, Clustering.class);
        if (arrayList.size() == 0) {
            ByLabelOrAllInOneClustering byLabelOrAllInOneClustering = new ByLabelOrAllInOneClustering();
            Object c = byLabelOrAllInOneClustering.run(database);
            ResultUtil.addChildResult(database, c);
        }
    }

    public static SelectionResult ensureSelectionResult(Database database) {
        ArrayList<SelectionResult> arrayList = ResultUtil.filterResults(database.getHierarchy(), database, SelectionResult.class);
        if (!arrayList.isEmpty()) {
            return (SelectionResult)arrayList.get(0);
        }
        SelectionResult selectionResult = new SelectionResult();
        ResultUtil.addChildResult(database, selectionResult);
        return selectionResult;
    }

    public static SamplingResult getSamplingResult(Relation<?> relation) {
        ArrayList<SamplingResult> arrayList = ResultUtil.filterResults(relation.getHierarchy(), relation, SamplingResult.class);
        if (arrayList.size() == 0) {
            SamplingResult samplingResult = new SamplingResult(relation);
            ResultUtil.addChildResult(relation, samplingResult);
            return samplingResult;
        }
        return (SamplingResult)arrayList.iterator().next();
    }

    public static ScalesResult getScalesResult(Relation<? extends SpatialComparable> relation) {
        ArrayList<ScalesResult> arrayList = ResultUtil.filterResults(relation.getHierarchy(), relation, ScalesResult.class);
        if (arrayList.size() == 0) {
            ScalesResult scalesResult = new ScalesResult(relation);
            ResultUtil.addChildResult(relation, scalesResult);
            return scalesResult;
        }
        return (ScalesResult)arrayList.iterator().next();
    }

    public static void addChildResult(HierarchicalResult hierarchicalResult, Result result) {
        hierarchicalResult.getHierarchy().add(hierarchicalResult, result);
    }

    public static Database findDatabase(ResultHierarchy resultHierarchy, Result result) {
        ArrayList<Database> arrayList = ResultUtil.filterResults(resultHierarchy, result, Database.class);
        return !arrayList.isEmpty() ? (Database)arrayList.get(0) : null;
    }

    public static Database findDatabase(ResultHierarchy resultHierarchy) {
        ArrayList<Database> arrayList = ResultUtil.filterResults(resultHierarchy, Database.class);
        return !arrayList.isEmpty() ? (Database)arrayList.get(0) : null;
    }

    public static void removeRecursive(ResultHierarchy resultHierarchy, Result result) {
        Hierarchy.Iter<Result> iter = resultHierarchy.iterParents(result);
        while (iter.valid()) {
            resultHierarchy.remove(iter.get(), result);
            iter.advance();
        }
        iter = resultHierarchy.iterChildren(result);
        while (iter.valid()) {
            ResultUtil.removeRecursive(resultHierarchy, iter.get());
            iter.advance();
        }
    }
}

