/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.AbstractSimpleProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection1D;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public class Simple1D
extends AbstractSimpleProjection
implements Projection1D {
    final int dnum;

    public Simple1D(Projector projector, LinearScale[] linearScaleArray, int n) {
        super(projector, linearScaleArray);
        this.dnum = n;
    }

    @Override
    public double fastProjectDataToRenderSpace(double[] dArray) {
        return (this.scales[this.dnum].getScaled(dArray[this.dnum]) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectDataToRenderSpace(NumberVector numberVector) {
        return (this.scales[this.dnum].getScaled(numberVector.doubleValue(this.dnum)) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectScaledToRender(double[] dArray) {
        return (dArray[this.dnum] - 0.5) * 100.0;
    }

    @Override
    public double fastProjectRelativeDataToRenderSpace(double[] dArray) {
        return (this.scales[this.dnum].getScaled(dArray[this.dnum]) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectRelativeDataToRenderSpace(NumberVector numberVector) {
        return (numberVector.doubleValue(this.dnum) - 0.5) * 100.0;
    }

    @Override
    public double fastProjectRelativeScaledToRender(double[] dArray) {
        return dArray[this.dnum] * 100.0;
    }

    @Override
    protected double[] rearrange(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = dArray[this.dnum];
        if (this.dnum > 0) {
            System.arraycopy(dArray, 0, dArray2, 1, this.dnum);
        }
        if (this.dnum + 1 < dArray.length) {
            System.arraycopy(dArray, this.dnum + 1, dArray2, this.dnum + 1, dArray.length - (this.dnum + 1));
        }
        return dArray2;
    }

    @Override
    protected double[] dearrange(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        if (this.dnum > 0) {
            System.arraycopy(dArray, 1, dArray2, 0, this.dnum);
        }
        dArray2[this.dnum] = dArray[0];
        if (this.dnum + 1 < dArray.length) {
            System.arraycopy(dArray, this.dnum + 1, dArray2, this.dnum + 1, dArray.length - (this.dnum + 1));
        }
        return dArray2;
    }

    @Override
    public String getMenuName() {
        return "Axis";
    }
}

