/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.OPTICSProjection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;

public abstract class AbstractOPTICSVisualization
extends AbstractVisualization {
    protected final OPTICSProjection optics;
    protected double plotwidth;
    protected double plotheight;

    public AbstractOPTICSVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        super(visualizationTask, visualizationPlot, d, d2);
        this.optics = (OPTICSProjection)projection;
    }

    protected void makeLayerElement() {
        this.plotwidth = 100.0;
        this.plotheight = 100.0 / this.optics.getOPTICSPlot(this.context).getRatio();
        double d = this.context.getStyleLibrary().getSize("margin");
        this.layer = SVGUtil.svgElement(this.svgp.getDocument(), "g");
        String string = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), this.plotwidth, this.plotheight, d * 0.5, d * 0.5, d * 1.5, d * 0.5);
        SVGUtil.setAtt(this.layer, "transform", string);
    }

    protected ClusterOrder getClusterOrder() {
        return this.optics.getResult();
    }
}

