/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class AxisVisibilityVisualization
extends AbstractVisFactory {
    private static final String NAME = "Axis Visibility";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ParallelPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ParallelPlotProjector.class);
        while (iter.valid()) {
            ParallelPlotProjector parallelPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, parallelPlotProjector.getRelation(), parallelPlotProjector.getRelation(), this);
            visualizationTask.level = 1000;
            visualizationTask.addFlags(5);
            visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            iter.advance();
        }
    }

    public class Instance
    extends AbstractParallelVisualization<NumberVector> {
        public static final String SELECTAXISVISIBILITY = "SelectAxisVisibility";
        public static final String SAV_BUTTON = "SAVbutton";
        public static final String SAV_BORDER = "SAVborder";
        public static final String SAV_CROSS = "SAVbuttoncross";
        double controlsize;
        double buttonsize;
        double ypos;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            int n = this.proj.getInputDimensionality();
            this.addCSSClasses(this.svgp);
            this.controlsize = 0.025 * this.getSizeY();
            this.buttonsize = 0.75 * this.controlsize;
            this.ypos = this.getSizeY() + this.getMarginTop() * 0.5;
            Element element = this.svgp.svgRect(-this.controlsize * 0.5, this.ypos - this.controlsize * 0.5 + this.buttonsize * 0.5, this.getSizeX() + this.controlsize, this.controlsize);
            SVGUtil.addCSSClass(element, SELECTAXISVISIBILITY);
            this.layer.appendChild(element);
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i <= n; ++i) {
                if (i < n && !this.proj.isAxisVisible(i)) {
                    ++n2;
                    continue;
                }
                if (n2 > 0) {
                    this.makeButtonsForHidden(n3, i - n2, n2, n);
                    n2 = 0;
                }
                if (i >= n) continue;
                this.makeButtonForVisible(i, n3);
                ++n3;
            }
        }

        protected void makeButtonForVisible(int n, int n2) {
            double d = this.getVisibleAxisX(n2) - this.buttonsize * 0.5;
            Element element = this.svgp.svgRect(d, this.ypos, this.buttonsize, this.buttonsize);
            SVGUtil.addCSSClass(element, SAV_BORDER);
            this.layer.appendChild(element);
            SVGPath sVGPath = new SVGPath();
            double d2 = this.controlsize * 0.5;
            double d3 = this.controlsize * 0.125;
            sVGPath.moveTo(d + d3, this.ypos + d3);
            sVGPath.relativeLineTo(d2, d2);
            sVGPath.relativeMoveTo(0.0, -d2);
            sVGPath.relativeLineTo(-d2, d2);
            Element element2 = sVGPath.makeElement(this.svgp);
            SVGUtil.addCSSClass(element2, SAV_CROSS);
            this.layer.appendChild(element2);
            Element element3 = this.svgp.svgRect(d, this.ypos, this.buttonsize, this.buttonsize);
            SVGUtil.addCSSClass(element3, SAV_BUTTON);
            this.addEventListener(element3, n);
            this.layer.appendChild(element3);
        }

        private void makeButtonsForHidden(int n, int n2, int n3, int n4) {
            double d = n == 0 ? -this.getMarginLeft() : this.getVisibleAxisX(n - 1);
            double d2 = n2 + n3 + 1 >= n4 ? this.getWidth() + this.getMarginLeft() : this.getVisibleAxisX(n);
            double d3 = (d2 - d) / ((double)n3 + 1.0);
            for (int i = 0; i < n3; ++i) {
                double d4 = d + (double)(i + 1) * d3 - this.buttonsize * 0.5;
                Element element = this.svgp.svgRect(d4, this.ypos, this.buttonsize, this.buttonsize);
                SVGUtil.addCSSClass(element, SAV_BORDER);
                this.layer.appendChild(element);
                Element element2 = this.svgp.svgRect(d4, this.ypos, this.buttonsize, this.buttonsize);
                SVGUtil.addCSSClass(element2, SAV_BUTTON);
                this.addEventListener(element2, n2 + i);
                this.layer.appendChild(element2);
            }
        }

        private void addEventListener(Element element, final int n) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            eventTarget.addEventListener("click", new EventListener(){

                @Override
                public void handleEvent(Event event) {
                    if (Instance.this.proj.getVisibleDimensions() > 2) {
                        Instance.this.proj.toggleAxisVisible(n);
                        Instance.this.context.visChanged(Instance.this.proj);
                    }
                }
            }, false);
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(SELECTAXISVISIBILITY)) {
                cSSClass = new CSSClass(this, SELECTAXISVISIBILITY);
                cSSClass.setStatement("opacity", 0.1);
                cSSClass.setStatement("fill", "blue");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(SAV_BORDER)) {
                cSSClass = new CSSClass(this, SAV_BORDER);
                cSSClass.setStatement("stroke", "grey");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 0.5);
                cSSClass.setStatement("fill", "none");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(SAV_BUTTON)) {
                cSSClass = new CSSClass(this, SAV_BUTTON);
                cSSClass.setStatement("opacity", 0.01);
                cSSClass.setStatement("fill", "grey");
                cSSClass.setStatement("cursor", "pointer");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(SAV_CROSS)) {
                cSSClass = new CSSClass(this, SAV_CROSS);
                cSSClass.setStatement("stroke", "black");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 0.75);
                cSSClass.setStatement("fill", "none");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

