/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.index;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.rstar.RStarTreeNode;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.ProjectionParallel;
import de.lmu.ifi.dbs.elki.visualization.projector.ParallelPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.parallel.AbstractParallelVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.index.TreeMBRVisualization;
import org.w3c.dom.Element;

public class RTreeParallelVisualization
extends AbstractVisFactory {
    public static final String INDEX = "parallelrtree";
    public static final String NAME = "R-Tree Index MBRs";
    protected Parameterizer settings;

    public RTreeParallelVisualization(Parameterizer parameterizer) {
        this.settings = parameterizer;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, AbstractRStarTree.class, ParallelPlotProjector.class, new VisualizationTree.Handler2<AbstractRStarTree<RStarTreeNode, SpatialEntry, ?>, ParallelPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, AbstractRStarTree<RStarTreeNode, SpatialEntry, ?> abstractRStarTree, ParallelPlotProjector<?> parallelPlotProjector) {
                VisualizationTask visualizationTask = new VisualizationTask(RTreeParallelVisualization.NAME, visualizerContext, abstractRStarTree, parallelPlotProjector.getRelation(), RTreeParallelVisualization.this);
                visualizationTask.level = 2;
                visualizationTask.default_visibility = false;
                visualizerContext.addVis(abstractRStarTree, visualizationTask);
                visualizerContext.addVis(parallelPlotProjector, visualizationTask);
            }
        });
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected boolean fill = true;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(TreeMBRVisualization.Parameterizer.FILL_ID);
            flag.setDefaultValue(Boolean.TRUE);
            if (parameterization.grab(flag)) {
                this.fill = flag.isTrue();
            }
        }

        @Override
        protected RTreeParallelVisualization makeInstance() {
            return new RTreeParallelVisualization(this);
        }
    }

    public class Instance<N extends AbstractRStarTreeNode<N, E>, E extends SpatialEntry>
    extends AbstractParallelVisualization<NumberVector>
    implements DataStoreListener {
        protected AbstractRStarTree<N, E, ?> tree;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.tree = (AbstractRStarTree)AbstractRStarTree.class.cast(visualizationTask.getResult());
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            super.fullRedraw();
            this.addCSSClasses(this.svgp);
            SpatialEntry spatialEntry = (SpatialEntry)this.tree.getRootEntry();
            this.visualizeRTreeEntry(this.svgp, this.layer, this.proj, this.tree, spatialEntry, 0, 0);
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            for (int i = 0; i < this.tree.getHeight(); ++i) {
                if (sVGPlot.getCSSClassManager().contains(RTreeParallelVisualization.INDEX + i)) continue;
                CSSClass cSSClass = new CSSClass(this, RTreeParallelVisualization.INDEX + i);
                double d = 1.0 - (double)i / (double)this.tree.getHeight();
                if (RTreeParallelVisualization.this.settings.fill) {
                    cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                    cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("plot"));
                    cSSClass.setStatement("fill", colorLibrary.getColor(i));
                    cSSClass.setStatement("fill-opacity", 0.2);
                } else {
                    cSSClass.setStatement("stroke", colorLibrary.getColor(i));
                    cSSClass.setStatement("stroke-width", d * styleLibrary.getLineWidth("plot"));
                    cSSClass.setStatement("fill", "none");
                }
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            sVGPlot.updateStyleElement();
        }

        private void visualizeRTreeEntry(SVGPlot sVGPlot, Element element, ProjectionParallel projectionParallel, AbstractRStarTree<? extends N, E, ?> abstractRStarTree, E e, int n, int n2) {
            int n3;
            int n4 = projectionParallel.getVisibleDimensions();
            double[] dArray = projectionParallel.fastProjectDataToRenderSpace(SpatialUtil.getMin(e));
            double[] dArray2 = projectionParallel.fastProjectDataToRenderSpace(SpatialUtil.getMax(e));
            assert (dArray.length == n4 && dArray2.length == n4);
            SVGPath sVGPath = new SVGPath();
            for (n3 = 0; n3 < n4; ++n3) {
                sVGPath.drawTo(this.getVisibleAxisX(n3), Math.max(dArray[n3], dArray2[n3]));
            }
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                sVGPath.drawTo(this.getVisibleAxisX(n3), Math.min(dArray[n3], dArray2[n3]));
            }
            sVGPath.close();
            Element element2 = sVGPath.makeElement(sVGPlot);
            SVGUtil.addCSSClass(element2, RTreeParallelVisualization.INDEX + n);
            element.appendChild(element2);
            if (!e.isLeafEntry()) {
                AbstractRStarTreeNode abstractRStarTreeNode = (AbstractRStarTreeNode)abstractRStarTree.getNode(e);
                for (int i = 0; i < abstractRStarTreeNode.getNumEntries(); ++i) {
                    SpatialEntry spatialEntry = (SpatialEntry)abstractRStarTreeNode.getEntry(i);
                    if (spatialEntry.isLeafEntry()) continue;
                    this.visualizeRTreeEntry(sVGPlot, element, projectionParallel, abstractRStarTree, spatialEntry, n + 1, ++n2);
                }
            }
        }
    }
}

