/*
 * Decompiled with CFR 0.152.
 */
package de.ugoe.cs.util.console.defaultcommands;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.CommandExecuter;
import de.ugoe.cs.util.console.Console;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.WordUtils;

public class CMDman
implements Command {
    @Override
    public void run(List<Object> parameters) {
        if (parameters.size() <= 0) {
            throw new IllegalArgumentException();
        }
        String command = (String)parameters.get(0);
        Command cmd = CommandExecuter.getInstance().getCMD(command);
        if (cmd != null) {
            InputStream manStream = ClassLoader.getSystemResourceAsStream("manuals/" + command);
            if (manStream != null) {
                try {
                    Console.println(WordUtils.wrap((String)IOUtils.toString((InputStream)manStream, (String)"UTF-8"), (int)100).replace("$USAGE$", "Usage: " + cmd.help()));
                }
                catch (IOException e) {
                    Console.printerrln("Failure reading man page");
                    Console.logException(e);
                }
            } else {
                Console.println("Usage: " + this.help());
            }
        } else {
            Console.println("Command " + command + " not found.");
        }
    }

    @Override
    public String help() {
        return "man <commandName>";
    }
}

