/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class NonUniformMutation
implements MutationOperator<DoubleSolution> {
    private double perturbation;
    private int maxIterations;
    private double mutationProbability;
    private int currentIteration;
    private JMetalRandom randomGenenerator;

    public NonUniformMutation(double mutationProbability, double perturbation, int maxIterations) {
        this.perturbation = perturbation;
        this.mutationProbability = mutationProbability;
        this.maxIterations = maxIterations;
        this.randomGenenerator = JMetalRandom.getInstance();
    }

    public double getPerturbation() {
        return this.perturbation;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public int getCurrentIteration() {
        return this.currentIteration;
    }

    public void setCurrentIteration(int currentIteration) {
        if (currentIteration < 0) {
            throw new JMetalException("Iteration number cannot be a negative value: " + currentIteration);
        }
        this.currentIteration = currentIteration;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            double tmp;
            if (!(this.randomGenenerator.nextDouble() < probability)) continue;
            double rand = this.randomGenenerator.nextDouble();
            if (rand <= 0.5) {
                tmp = this.delta(solution.getUpperBound(i) - (Double)solution.getVariableValue(i), this.perturbation);
                tmp += ((Double)solution.getVariableValue(i)).doubleValue();
            } else {
                tmp = this.delta(solution.getLowerBound(i) - (Double)solution.getVariableValue(i), this.perturbation);
                tmp += ((Double)solution.getVariableValue(i)).doubleValue();
            }
            if (tmp < solution.getLowerBound(i)) {
                tmp = solution.getLowerBound(i);
            } else if (tmp > solution.getUpperBound(i)) {
                tmp = solution.getUpperBound(i);
            }
            solution.setVariableValue(i, tmp);
        }
    }

    private double delta(double y, double bMutationParameter) {
        double rand = this.randomGenenerator.nextDouble();
        int it = this.currentIteration;
        int maxIt = this.maxIterations;
        return y * (1.0 - Math.pow(rand, Math.pow(1.0 - (double)it / (double)maxIt, bMutationParameter)));
    }
}

