/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.EglTemplate;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.formatter.Formatter;
import org.eclipse.epsilon.eol.EolImport;
import org.eclipse.epsilon.eol.EolModelDefinition;
import org.eclipse.epsilon.eol.EolModelGroupDefinition;
import org.eclipse.epsilon.eol.EolOperationFactory;
import org.eclipse.epsilon.eol.EolOperations;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.IEolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class EglTemplateFactoryModuleAdapter
implements IEolExecutableModule {
    private final EglTemplateFactory factory;
    private EglTemplate current;

    public EglTemplateFactoryModuleAdapter(EglTemplateFactory factory) {
        this.factory = factory;
    }

    public EglTemplate getCurrentTemplate() {
        return this.current;
    }

    @Override
    public boolean parse(File file) throws Exception {
        this.current = this.factory.load(file);
        return this.getParseProblems().isEmpty();
    }

    @Override
    public boolean parse(URI uri) throws Exception {
        this.current = this.factory.load(uri);
        return this.getParseProblems().isEmpty();
    }

    @Override
    public boolean parse(String code) throws Exception {
        this.current = this.factory.prepare(code);
        return this.getParseProblems().isEmpty();
    }

    @Override
    public boolean parse(String code, File file) throws Exception {
        this.current = this.factory.load(code, file);
        return this.current.getParseProblems().isEmpty();
    }

    @Override
    public List<ParseProblem> getParseProblems() {
        return this.current == null ? new LinkedList() : this.current.getParseProblems();
    }

    @Override
    public Object execute() throws EolRuntimeException {
        return this.current == null ? null : this.current.process();
    }

    @Override
    public AST getAst() {
        return this.current == null ? null : this.current.getAst();
    }

    @Override
    public void reset() {
        this.current = null;
    }

    @Override
    public void buildModel() throws Exception {
    }

    @Override
    public List<?> getChildren() {
        return this.current == null ? Collections.emptyList() : this.current.getChildren();
    }

    @Override
    public IEglContext getContext() {
        return this.factory.getContext();
    }

    @Override
    public List<EolModelDefinition> getDeclaredModelDefinitions() {
        return this.current.getDeclaredModelDefinitions();
    }

    @Override
    public List<EolModelGroupDefinition> getDeclaredModelGroupDefinitions() {
        return this.current.getDeclaredModelGroupDefinitions();
    }

    @Override
    public EolOperations getDeclaredOperations() {
        return this.current.getDeclaredOperations();
    }

    @Override
    public List<EolImport> getImports() {
        return this.current.getImports();
    }

    @Override
    public Set<EolModelDefinition> getModelDefinitions() {
        return this.current.getModelDefinitions();
    }

    @Override
    public Set<EolModelGroupDefinition> getModelGroupDefinitions() {
        return this.current.getModelGroupDefinitions();
    }

    @Override
    public EolOperationFactory getOperationFactory() {
        return this.current.getOperationFactory();
    }

    @Override
    public EolOperations getOperations() {
        return this.current.getOperations();
    }

    @Override
    public void setOperationFactory(EolOperationFactory operationFactory) {
        this.current.setOperationFactory(operationFactory);
    }

    public void setDefaultFormatters(Collection<Formatter> defaultFormatters) {
        this.factory.setDefaultFormatters(defaultFormatters);
    }

    @Override
    public IEolLibraryModule getParentModule() {
        return null;
    }

    @Override
    public void setParentModule(IEolLibraryModule parent) {
    }

    @Override
    public URI getSourceUri() {
        return null;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IEglContext) {
            this.factory.setContext((IEglContext)context);
        }
    }
}

