/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eml.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.eml.MergeRule;
import org.eclipse.epsilon.eml.MergeRules;
import org.eclipse.epsilon.eml.execute.context.IEmlContext;
import org.eclipse.epsilon.eml.strategy.IMergingStrategy;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.rules.INamedRule;
import org.eclipse.epsilon.etl.strategy.DefaultTransformationStrategy;

public class DefaultMergingStrategy
extends DefaultTransformationStrategy
implements IMergingStrategy {
    protected IEmlContext context = null;
    protected List<Object> excluded = null;

    @Override
    public void mergeModels(IEmlContext context) throws EolRuntimeException {
        this.context = context;
        for (Match match : context.getMatchTrace().getMatches()) {
            MergeRules rules = context.getModule().getMergeRules().getRulesFor(match, context);
            for (INamedRule rule : rules) {
                MergeRule mergeRule = (MergeRule)rule;
                if (mergeRule.isLazy(context) || mergeRule.hasMerged(match)) continue;
                mergeRule.merge(match, context);
            }
        }
        this.transformModels(context);
    }

    @Override
    public Collection<?> getEquivalents(Object source, IEolContext context, List<String> rules) throws EolRuntimeException {
        if (!this.getExcluded().contains(source)) {
            return super.getEquivalents(source, context, rules);
        }
        return this.merge(source, context, rules);
    }

    private Collection<Object> merge(Object source, IEolContext context_, List<String> rules) throws EolRuntimeException {
        List<Match> matches = this.context.getMatchTrace().getMatches(source);
        List<Object> targets = CollectionUtil.createDefaultList();
        for (Match match : matches) {
            for (INamedRule rule : this.context.getModule().getMergeRules().getRulesFor(match, this.context)) {
                MergeRule mergeRule = (MergeRule)rule;
                if (rules != null && !rules.contains(rule.getName())) continue;
                Collection<?> merged = mergeRule.merge(match, this.context);
                if (!mergeRule.isPrimary(this.context)) {
                    targets.addAll(merged);
                    continue;
                }
                int i = 0;
                for (Object target : merged) {
                    targets.add(i, target);
                    ++i;
                }
            }
        }
        return targets;
    }

    @Override
    public List<Object> getExcluded() {
        if (this.excluded == null) {
            this.excluded = new ArrayList<Object>();
            for (Match match : this.context.getMatchTrace().getMatches()) {
                this.excluded.add(match.getLeft());
                this.excluded.add(match.getRight());
            }
        }
        return this.excluded;
    }
}

