/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.loader;

import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.model.domain.MigrationStrategy;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.loader.DeletionLoader;
import org.eclipse.epsilon.flock.model.loader.MigrateRuleLoader;
import org.eclipse.epsilon.flock.model.loader.PackageDeletionLoader;
import org.eclipse.epsilon.flock.model.loader.PackageRetypingLoader;
import org.eclipse.epsilon.flock.model.loader.RetypingLoader;

public class MigrationStrategyLoader {
    private AST ast;

    public MigrationStrategyLoader(AST ast) {
        this.ast = ast;
    }

    public MigrationStrategy run() {
        MigrationStrategy strategy = new MigrationStrategy(new ClassifierTypedConstruct[0]);
        for (AST childAst : this.ast.getChildren()) {
            switch (childAst.getType()) {
                case 84: {
                    strategy.addRule(new MigrateRuleLoader(childAst).run());
                    break;
                }
                case 81: {
                    strategy.addTypeMappingConstruct(new RetypingLoader(childAst).run());
                    break;
                }
                case 82: {
                    strategy.addTypeMappingConstruct(new PackageRetypingLoader(childAst).run());
                    break;
                }
                case 52: {
                    strategy.addTypeMappingConstruct(new DeletionLoader(childAst).run());
                    break;
                }
                case 83: {
                    strategy.addTypeMappingConstruct(new PackageDeletionLoader(childAst).run());
                }
            }
        }
        return strategy;
    }
}

