/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.antlr.postprocessor.model.antlrAst.Ast;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.AbstractEmfModel;
import org.eclipse.epsilon.emc.emf.EmfUtil;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.EolLibraryModule;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.hutn.HutnContext;
import org.eclipse.epsilon.hutn.HutnDocument;
import org.eclipse.epsilon.hutn.IHutnContext;
import org.eclipse.epsilon.hutn.IHutnModule;
import org.eclipse.epsilon.hutn.exceptions.HutnConfigFileNotFoundException;
import org.eclipse.epsilon.hutn.exceptions.HutnException;
import org.eclipse.epsilon.hutn.exceptions.HutnGenerationException;
import org.eclipse.epsilon.hutn.exceptions.HutnUnrecognisedNsUriException;
import org.eclipse.epsilon.hutn.generate.metamodel.MetaModelGenerator;
import org.eclipse.epsilon.hutn.generate.model.ModelGenerator;
import org.eclipse.epsilon.hutn.model.hutn.HutnPackage;
import org.eclipse.epsilon.hutn.model.hutn.NsUri;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.parse.HutnLexer;
import org.eclipse.epsilon.hutn.parse.HutnParser;
import org.eclipse.epsilon.hutn.parse.postprocessor.HutnPostProcessor;
import org.eclipse.epsilon.hutn.translate.HutnTranslator;
import org.eclipse.epsilon.hutn.validation.model.HutnValidator;

public class HutnModule
extends EolLibraryModule
implements IHutnModule {
    protected IHutnContext context;
    protected HutnDocument document;
    protected Spec spec;
    protected boolean metaModelIsValid = true;
    protected File configFileDirectory;
    protected boolean hutnIsValid = false;

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new HutnLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new HutnParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "document";
    }

    @Override
    public IHutnContext getContext() {
        return this.context;
    }

    @Override
    public void reset() {
        super.reset();
        this.context = new HutnContext(this);
        this.metaModelIsValid = true;
        this.hutnIsValid = false;
    }

    @Override
    protected boolean invokeMainRule() throws Exception {
        boolean buildModelWasCalled = super.invokeMainRule();
        if (buildModelWasCalled) {
            return this.parsingWasSuccessful();
        }
        return false;
    }

    protected boolean parsingWasSuccessful() {
        for (ParseProblem p : this.getParseProblems()) {
            if (p.getSeverity() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        this.document = new HutnDocument();
        this.document.setAst(this.ast);
        this.translateAst();
    }

    protected void translateAst() throws HutnException {
        try {
            Ast astModel = new HutnPostProcessor(this.getParseProblems()).process(this.ast);
            HutnTranslator translator = new HutnTranslator(this.configFileDirectory);
            this.getParseProblems().addAll(translator.validateConfigModel(astModel));
            this.hutnIsValid = this.parsingWasSuccessful();
            if (this.hutnIsValid) {
                this.spec = translator.createIntermediateModel(astModel, this.sourceFile);
                if (this.spec == null) {
                    throw new IllegalArgumentException("Could not generate Intermediate model for specified text.");
                }
                this.getParseProblems().addAll(new HutnValidator().getProblemsForIntermediateModel(this.spec));
            }
        }
        catch (HutnConfigFileNotFoundException e) {
            this.getParseProblems().add(new ParseProblem(e.getLine(), e.getColumn(), "Configuration file not found: " + e.getPath()));
        }
        catch (HutnUnrecognisedNsUriException e) {
            this.getParseProblems().add(new ParseProblem(e.getLine(), e.getColumn(), "Unrecognised namespace URI: " + e.getUri()));
            this.metaModelIsValid = false;
        }
    }

    @Override
    public boolean hasValidHutn() {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        return this.hutnIsValid;
    }

    @Override
    public void setConfigFileDirectory(File configFileDirectory) {
        this.configFileDirectory = configFileDirectory;
    }

    @Override
    public boolean hasValidMetaModel() {
        return this.metaModelIsValid;
    }

    @Override
    public List<String> getNsUris() {
        LinkedList<String> nsUris = new LinkedList<String>();
        if (this.spec != null) {
            for (NsUri uri : this.spec.getNsUris()) {
                nsUris.add(uri.getValue());
            }
        }
        return Collections.unmodifiableList(nsUris);
    }

    @Override
    public String getModelFile() {
        if (this.spec != null) {
            return this.spec.getModelFile();
        }
        return null;
    }

    @Override
    public AbstractEmfModel generateEmfModel() throws HutnGenerationException {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        if (this.hasInferredMetaModel()) {
            throw new IllegalStateException("Cannot generate an in-memory model when the metamodel needs to be inferred.");
        }
        return new ModelGenerator(this.spec).generate(this.spec.getModelFile());
    }

    @Override
    public List<File> storeEmfModel(File baseDirectory, String defaultModelPath, String inferredMetamodelPath) throws HutnGenerationException {
        ModelGenerator generator;
        LinkedList<File> generated = new LinkedList<File>();
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        if (this.hasInferredMetaModel()) {
            File metamodel = new File(baseDirectory, inferredMetamodelPath);
            this.generateEmfMetaModel(metamodel);
            generator = new ModelGenerator(this.spec, metamodel);
            generated.add(metamodel);
        } else {
            generator = new ModelGenerator(this.spec);
        }
        File model = this.spec.getModelFile() == null ? new File(baseDirectory, defaultModelPath) : new File(baseDirectory, this.spec.getModelFile());
        generator.store(model);
        generated.add(model);
        return generated;
    }

    private boolean hasInferredMetaModel() {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        return this.spec.getNsUris().isEmpty();
    }

    private void generateEmfMetaModel(File destination) throws HutnGenerationException {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        new MetaModelGenerator(this.spec).store(destination);
    }

    @Override
    public Spec getIntermediateModel() {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        return this.spec;
    }

    @Override
    public void storeIntermediateModel(File destination) {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        URI fileUri = URI.createFileURI(destination.getAbsolutePath());
        Resource resource = EmfUtil.createResource(fileUri);
        resource.getContents().add(this.spec);
        InMemoryEmfModel model = new InMemoryEmfModel("Intermediate", resource, HutnPackage.eINSTANCE);
        model.store(fileUri);
        model.dispose();
    }

    @Override
    public void storeIntermediateModelTransformation(File destination) throws HutnGenerationException {
        this.storeIntermediateModelTransformation(destination, false);
    }

    @Override
    public void storeIntermediateModelTransformationForAllInputModels(File destination) throws HutnGenerationException {
        this.storeIntermediateModelTransformation(destination, true);
    }

    private void storeIntermediateModelTransformation(File destination, boolean generateCompleteTransformation) throws HutnGenerationException {
        if (this.spec == null) {
            throw new IllegalStateException("No HUTN has been parsed.");
        }
        try {
            ModelGenerator modelGenerator = new ModelGenerator(this.spec);
            if (generateCompleteTransformation) {
                modelGenerator.forceGenerationOfTransformationForWholeMetamodel();
            }
            FileWriter writer = new FileWriter(destination);
            writer.write(modelGenerator.generateTransformation());
            writer.close();
        }
        catch (IOException e) {
            throw new HutnGenerationException(e);
        }
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IHutnContext) {
            this.context = (IHutnContext)context;
        }
    }
}

