/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.audit;

import java.util.List;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.GeneticOperator;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.RandomGenerator;

public class PermutingConfiguration
extends Configuration {
    private static final String CVS_REVISION = "$Revision: 1.9 $";
    private List m_randomGeneratorSlots;
    private int m_randomGeneratorIndex;
    private List m_naturalSelectorSlots;
    private int m_naturalSelectorIndex;
    private List m_geneticOperatorSlots;
    private int m_geneticOperatorIndex;
    private List m_fitnessFunctionSlots;
    private int m_fitnessFunctionIndex;
    private int m_componentIndex;
    private Configuration m_configuration;

    public PermutingConfiguration() {
        this.init();
    }

    public void init() {
        this.m_randomGeneratorSlots = new Vector();
        this.m_naturalSelectorSlots = new Vector();
        this.m_geneticOperatorSlots = new Vector();
        this.m_fitnessFunctionSlots = new Vector();
        this.m_randomGeneratorIndex = 0;
        this.m_naturalSelectorIndex = 0;
        this.m_geneticOperatorIndex = 0;
        this.m_fitnessFunctionIndex = 0;
        this.m_componentIndex = 0;
    }

    public PermutingConfiguration(Configuration a_conf) throws InvalidConfigurationException {
        this();
        this.setEventManager(a_conf.getEventManager());
        this.setFitnessEvaluator(a_conf.getFitnessEvaluator());
        if (a_conf.getFitnessFunction() != null) {
            this.setFitnessFunction(a_conf.getFitnessFunction());
        }
        this.setMinimumPopSizePercent(a_conf.getMinimumPopSizePercent());
        if (a_conf.getPopulationSize() > 0) {
            this.setPopulationSize(a_conf.getPopulationSize());
        }
        if (a_conf.getSampleChromosome() != null) {
            this.setSampleChromosome(a_conf.getSampleChromosome());
        }
        this.setRandomGenerator(a_conf.getRandomGenerator());
        if (a_conf.getChromosomePool() != null) {
            this.setChromosomePool(a_conf.getChromosomePool());
        }
    }

    public void addRandomGeneratorSlot(RandomGenerator a_randomGenerator) {
        this.m_randomGeneratorSlots.add(a_randomGenerator);
    }

    public void addNaturalSelector(NaturalSelector a_naturalSel, boolean a_egal) {
        throw new UnsupportedOperationException("Use addNaturalSelectorSlot instead!");
    }

    public void addNaturalSelectorSlot(NaturalSelector a_naturalSelector) {
        this.m_naturalSelectorSlots.add(a_naturalSelector);
    }

    public synchronized void addGeneticOperator(GeneticOperator a_geneticOp) {
        throw new UnsupportedOperationException("Use addGeneticOperatorSlot instead!");
    }

    public void addGeneticOperatorSlot(GeneticOperator a_geneticOperator) {
        this.m_geneticOperatorSlots.add(a_geneticOperator);
    }

    public void addFitnessFunctionSlot(FitnessFunction a_fitnessFunction) {
        this.m_fitnessFunctionSlots.add(a_fitnessFunction);
    }

    public Configuration next() throws InvalidConfigurationException {
        this.m_configuration = new Configuration();
        this.m_configuration.setEventManager(this.getEventManager());
        this.m_configuration.setFitnessEvaluator(this.getFitnessEvaluator());
        if (this.getFitnessFunction() != null) {
            Configuration.resetProperty("JGAPFITFUNCINST");
            this.setFitnessFunction(this.getFitnessFunction());
        }
        this.m_configuration.setMinimumPopSizePercent(this.getMinimumPopSizePercent());
        if (this.getPopulationSize() > 0) {
            this.m_configuration.setPopulationSize(this.getPopulationSize());
        }
        if (this.getSampleChromosome() != null) {
            this.m_configuration.setSampleChromosome(this.getSampleChromosome());
        }
        this.m_configuration.setRandomGenerator(this.getRandomGenerator());
        if (this.getChromosomePool() != null) {
            this.m_configuration.setChromosomePool(this.getChromosomePool());
        }
        if ((double)this.m_geneticOperatorIndex >= Math.pow(2.0, this.m_geneticOperatorSlots.size()) - 1.0) {
            this.m_geneticOperatorIndex = 0;
            ++this.m_naturalSelectorIndex;
        }
        List list = this.nextList(this.m_geneticOperatorIndex++, this.m_geneticOperatorSlots);
        for (GeneticOperator op : list) {
            this.m_configuration.addGeneticOperator(op);
        }
        if ((double)this.m_naturalSelectorIndex >= Math.pow(2.0, this.m_naturalSelectorSlots.size()) - 1.0) {
            this.m_naturalSelectorIndex = 0;
            ++this.m_randomGeneratorIndex;
        }
        list = this.nextList(this.m_naturalSelectorIndex, this.m_naturalSelectorSlots);
        for (NaturalSelector ns : list) {
            this.m_configuration.addNaturalSelector(ns, true);
        }
        ++this.m_randomGeneratorIndex;
        if (this.m_randomGeneratorIndex >= this.m_randomGeneratorSlots.size()) {
            this.m_randomGeneratorIndex = 0;
            ++this.m_fitnessFunctionIndex;
        }
        RandomGenerator rg = (RandomGenerator)this.m_randomGeneratorSlots.get(this.m_randomGeneratorIndex);
        this.m_configuration.setRandomGenerator(rg);
        ++this.m_fitnessFunctionIndex;
        if (this.m_fitnessFunctionIndex >= this.m_fitnessFunctionSlots.size()) {
            this.m_fitnessFunctionIndex = 0;
        }
        FitnessFunction ff = (FitnessFunction)this.m_fitnessFunctionSlots.get(this.m_fitnessFunctionIndex);
        PermutingConfiguration permutingConfiguration = this;
        permutingConfiguration.m_configuration.reset();
        this.m_configuration.setFitnessFunction(ff);
        ++this.m_componentIndex;
        return this.m_configuration;
    }

    private List nextList(int index, List list) {
        index = index <= 0 ? 1 : ++index;
        Vector newList = new Vector();
        for (int i = 0; i < list.size(); ++i) {
            if ((index & (int)Math.pow(2.0, i)) <= 0) continue;
            newList.add(list.get(i));
        }
        return newList;
    }

    public boolean hasNext() {
        double r = (double)(this.m_randomGeneratorSlots.size() * this.m_fitnessFunctionSlots.size()) * (Math.pow(2.0, this.m_naturalSelectorSlots.size()) - 1.0) * (Math.pow(2.0, this.m_geneticOperatorSlots.size()) - 1.0);
        return (double)this.m_componentIndex < r;
    }
}

