/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.data;

import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.Population;
import org.jgap.data.DataElement;
import org.jgap.data.DataElementList;
import org.jgap.data.DataElementsDocument;
import org.jgap.data.IDataCreators;
import org.jgap.data.IDataElement;
import org.jgap.data.IDataElementList;

public class DataTreeBuilder {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    private static final String GENOTYPE_TAG = "genotype";
    private static final String CHROMOSOME_TAG = "chromosome";
    private static final String GENES_TAG = "genes";
    private static final String GENE_TAG = "gene";
    private static final String ALLELE_TAG = "allele";
    private static final String SIZE_ATTRIBUTE = "size";
    private static final String CLASS_ATTRIBUTE = "class";
    private Object m_lock;
    private static DataTreeBuilder m_instance;

    public static synchronized DataTreeBuilder getInstance() {
        if (m_instance == null) {
            m_instance = new DataTreeBuilder();
            DataTreeBuilder.m_instance.m_lock = new Object();
        }
        return m_instance;
    }

    private DataTreeBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataCreators representGenotypeAsDocument(Genotype a_subject) throws Exception {
        DataElementsDocument genotypeDocument;
        Object object = this.m_lock;
        synchronized (object) {
            genotypeDocument = new DataElementsDocument();
            genotypeDocument.setTree(this.createTree());
        }
        IDataElement genotypeElement = this.representGenotypeAsElement(a_subject);
        genotypeDocument.appendChild(genotypeElement);
        return genotypeDocument;
    }

    public IDataElement representGenotypeAsElement(Genotype a_subject) throws Exception {
        Population population = a_subject.getPopulation();
        DataElement genotypeTag = new DataElement(GENOTYPE_TAG);
        genotypeTag.setAttribute(SIZE_ATTRIBUTE, Integer.toString(population.size()));
        for (int i = 0; i < population.size(); ++i) {
            IDataElement chromosomeElement = this.representChromosomeAsElement(population.getChromosome(i));
            genotypeTag.appendChild(chromosomeElement);
        }
        return genotypeTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataCreators representChromosomeAsDocument(IChromosome a_subject) throws Exception {
        DataElementsDocument chromosomeDocument;
        Object object = this.m_lock;
        synchronized (object) {
            chromosomeDocument = new DataElementsDocument();
            chromosomeDocument.setTree(this.createTree());
        }
        IDataElement chromosomeElement = this.representChromosomeAsElement(a_subject);
        chromosomeDocument.appendChild(chromosomeElement);
        return chromosomeDocument;
    }

    protected IDataElementList createTree() {
        return new DataElementList();
    }

    public IDataElement representChromosomeAsElement(IChromosome a_subject) throws Exception {
        DataElement chromosomeElement = new DataElement(CHROMOSOME_TAG);
        chromosomeElement.setAttribute(SIZE_ATTRIBUTE, Integer.toString(a_subject.size()));
        IDataElement genesElement = this.representGenesAsElement(a_subject.getGenes());
        chromosomeElement.appendChild(genesElement);
        return chromosomeElement;
    }

    public IDataElement representGenesAsElement(Gene[] a_geneValues) throws Exception {
        DataElement genesElement = new DataElement(GENES_TAG);
        for (int i = 0; i < a_geneValues.length; ++i) {
            IDataElement geneElement = this.representGeneAsElement(a_geneValues[i]);
            genesElement.appendChild(geneElement);
        }
        return genesElement;
    }

    public IDataElement representGeneAsElement(Gene a_gene) throws Exception {
        DataElement geneElement = new DataElement(GENE_TAG);
        geneElement.setAttribute(CLASS_ATTRIBUTE, a_gene.getClass().getName());
        geneElement.appendChild(this.representAlleleAsElement(a_gene));
        return geneElement;
    }

    private IDataElement representAlleleAsElement(Gene a_gene) throws Exception {
        DataElement alleleElement = new DataElement(ALLELE_TAG);
        alleleElement.setAttribute("value", a_gene.getPersistentRepresentation());
        return alleleElement;
    }
}

