/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid.gp;

import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.WorkResult;
import org.homedns.dade.jcgrid.worker.Worker;
import org.jgap.distr.grid.gp.JGAPRequestGP;
import org.jgap.distr.grid.gp.JGAPResultGP;
import org.jgap.distr.grid.gp.JGAPWorkersGP;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;

public class JGAPWorkerGP
implements Worker {
    private static final String CVS_REVISION = "$Revision: 1.4 $";

    public WorkResult doWork(WorkRequest work, String workDir) throws Exception {
        long start = System.currentTimeMillis();
        JGAPRequestGP req = (JGAPRequestGP)work;
        GPConfiguration conf = req.getConfiguration();
        if (conf.getJGAPFactory() == null) {
            throw new IllegalStateException("JGAPFactory must not be null!");
        }
        conf = conf.newInstanceGP(conf.getId() + "_1", conf.getName() + "_1");
        req.setConfiguration(conf);
        GPGenotype gen = null;
        if (req.getGenotypeInitializer() != null) {
            GPPopulation initialPop = req.getPopulation();
            gen = req.getGenotypeInitializer().setupGenotype(req, initialPop);
            if (req.getWorkerEvolveStrategy() != null) {
                req.getWorkerEvolveStrategy().evolve(gen);
            }
        }
        JGAPResultGP res = req.getWorkerReturnStrategy().assembleResult(req, gen);
        long duration = System.currentTimeMillis() - start;
        if (JGAPResultGP.class.isAssignableFrom(((Object)((Object)res)).getClass())) {
            JGAPResultGP resJGAP = res;
            resJGAP.setDurationComputation(duration);
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        new JGAPWorkersGP(args);
    }
}

