/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.ReadTerminal;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class AddAndStoreTerminal
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private String m_storageName;
    private Class m_type;

    public AddAndStoreTerminal(GPConfiguration a_conf, String a_storageName, Class a_childType) throws InvalidConfigurationException {
        this(a_conf, a_storageName, a_childType, 0, 0);
    }

    public AddAndStoreTerminal(GPConfiguration a_conf, String a_storageName, Class a_childType, int a_subReturnType, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.VoidClass, a_subReturnType, new int[]{a_subChildType});
        this.m_type = a_childType;
        if (a_storageName == null || a_storageName.length() < 1) {
            throw new IllegalArgumentException("Memory name must not be empty!");
        }
        this.m_storageName = a_storageName;
    }

    public String toString() {
        return "addstore(" + this.m_storageName + ", &1)";
    }

    public String getName() {
        return "Add+Store Terminal";
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        if (this.m_type == CommandGene.IntegerClass) {
            int value = c.execute_int(n, 0, args);
            Integer oldValue = (Integer)this.getGPConfiguration().readFromMemoryIfExists(this.m_storageName);
            if (oldValue != null) {
                value += oldValue.intValue();
            }
            this.getGPConfiguration().storeInMemory(this.m_storageName, new Integer(value));
        } else if (this.m_type == CommandGene.LongClass) {
            long value = c.execute_long(n, 0, args);
            Long oldValue = (Long)this.getGPConfiguration().readFromMemoryIfExists(this.m_storageName);
            if (oldValue != null) {
                value += oldValue.longValue();
            }
            this.getGPConfiguration().storeInMemory(this.m_storageName, new Long(value));
        } else if (this.m_type == CommandGene.DoubleClass) {
            double value = c.execute_double(n, 0, args);
            Double oldValue = (Double)this.getGPConfiguration().readFromMemoryIfExists(this.m_storageName);
            if (oldValue != null) {
                value += oldValue.doubleValue();
            }
            this.getGPConfiguration().storeInMemory(this.m_storageName, new Double(value));
        } else if (this.m_type == CommandGene.FloatClass) {
            float value = c.execute_float(n, 0, args);
            Float oldValue = (Float)this.getGPConfiguration().readFromMemoryIfExists(this.m_storageName);
            if (oldValue != null) {
                value += oldValue.floatValue();
            }
            this.getGPConfiguration().storeInMemory(this.m_storageName, new Float(value));
        } else {
            throw new IllegalStateException("Type " + this.m_type + " unknown");
        }
    }

    public boolean isAffectGlobalState() {
        return true;
    }

    public boolean isValid(ProgramChromosome a_program) {
        return a_program.getIndividual().getCommandOfClass(0, ReadTerminal.class) > 0;
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return this.m_type;
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        AddAndStoreTerminal other = (AddAndStoreTerminal)a_other;
        return new CompareToBuilder().append((Object)this.m_storageName, (Object)other.m_storageName).append((Object)this.m_type, (Object)other.m_type).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            AddAndStoreTerminal other = (AddAndStoreTerminal)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_storageName, (Object)other.m_storageName).append((Object)this.m_type, (Object)other.m_type).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            AddAndStoreTerminal result = new AddAndStoreTerminal(this.getGPConfiguration(), this.m_storageName, this.m_type, this.getSubReturnType(), this.getSubChildType(0));
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }
}

