/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.jgap.InvalidConfigurationException;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Exp
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.9 $";

    public Exp(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        super(a_conf, 1, a_returnType);
    }

    public String toString() {
        return "Exp(&1)";
    }

    public String getName() {
        return "Exp";
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        int i = c.execute_int(n, 0, args);
        return (int)Math.exp(Math.max(-10000.0f, Math.min((float)i, 20.0f)));
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        float f = c.execute_float(n, 0, args);
        return (float)Math.exp(Math.max(-10000.0f, Math.min(f, 20.0f)));
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        double f = c.execute_double(n, 0, args);
        return Math.exp(Math.max(-10000.0, Math.min(f, 20.0)));
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        return ((Compatible)c.execute_object(n, 0, args)).execute_exp();
    }

    public Object clone() {
        try {
            Exp result = new Exp(this.getGPConfiguration(), this.getReturnType());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    protected static interface Compatible {
        public Object execute_exp();
    }
}

