/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jgap.BreederBase;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.IChromosome;
import org.jgap.IInitializer;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.event.GeneticEvent;

public class GABreeder
extends BreederBase {
    private static final String CVS_REVISION = "$Revision: 1.21 $";
    private transient Configuration m_lastConf;
    private transient Population m_lastPop;
    List<IChromosome> m_allChromosomesSoFar = new ArrayList<IChromosome>();

    public Population evolve(Population a_pop, Configuration a_conf) {
        Population pop = a_pop;
        BulkFitnessFunction bulkFunction = a_conf.getBulkFitnessFunction();
        boolean monitorActive = a_conf.getMonitor() != null;
        IChromosome fittest = null;
        if (a_conf.getGenerationNr() == 0) {
            int size = pop.size();
            for (int i = 0; i < size; ++i) {
                IChromosome chrom = pop.getChromosome(i);
                chrom.increaseAge();
            }
            if (bulkFunction != null) {
                try {
                    pop = this.bulkFunctionEvaluation(a_conf, bulkFunction, pop, monitorActive);
                }
                catch (InvalidConfigurationException ex) {
                    throw new RuntimeException(ex);
                }
                a_conf.incrementGenerationNr();
                this.m_lastPop = pop;
                this.m_lastConf = a_conf;
                a_conf.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
                return pop;
            }
        } else if (a_conf.isPreserveFittestIndividual()) {
            fittest = pop.determineFittestChromosome(0, pop.size() - 1);
        }
        if (a_conf.getGenerationNr() > 0 && bulkFunction == null) {
            this.keepPopSizeConstant(pop, a_conf);
        }
        if (monitorActive) {
            a_conf.getMonitor().event("before_update_chromosomes(1)", a_conf.getGenerationNr(), new Object[]{pop});
        }
        this.updateChromosomes(pop, a_conf);
        if (monitorActive) {
            a_conf.getMonitor().event("after_update_chromosomes(1)", a_conf.getGenerationNr(), new Object[]{pop});
        }
        pop = this.applyNaturalSelectors(a_conf, pop, true);
        int newChromIndex = pop.size();
        this.applyGeneticOperators(a_conf, pop);
        int currentPopSize = pop.size();
        for (int i = newChromIndex; i < currentPopSize; ++i) {
            IChromosome chrom = pop.getChromosome(i);
            chrom.setFitnessValueDirectly(-1.0);
            chrom.resetAge();
            chrom.increaseOperatedOn();
        }
        int size = Math.min(newChromIndex, currentPopSize);
        for (int i = 0; i < size; ++i) {
            IChromosome chrom = pop.getChromosome(i);
            chrom.increaseAge();
            chrom.resetOperatedOn();
        }
        if (bulkFunction != null & a_conf.getGenerationNr() > 0) {
            try {
                pop = this.bulkFunctionEvaluation(a_conf, bulkFunction, pop, monitorActive);
            }
            catch (InvalidConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (monitorActive) {
            a_conf.getMonitor().event("before_update_chromosomes(2)", a_conf.getGenerationNr(), new Object[]{pop});
        }
        this.updateChromosomes(pop, a_conf);
        if (monitorActive) {
            a_conf.getMonitor().event("after_update_chromosomes(2)", a_conf.getGenerationNr(), new Object[]{pop});
        }
        pop = this.applyNaturalSelectors(a_conf, pop, false);
        this.fillPopulationRandomlyToOriginalSize(a_conf, pop);
        IChromosome newFittest = this.reAddFittest(pop, fittest);
        if (monitorActive && newFittest != null) {
            a_conf.getMonitor().event("readd_fittest_chromosome", a_conf.getGenerationNr(), new Object[]{pop, fittest});
        }
        a_conf.incrementGenerationNr();
        this.m_lastPop = pop;
        this.m_lastConf = a_conf;
        a_conf.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
        return pop;
    }

    private void fillPopulationRandomlyToOriginalSize(Configuration a_conf, Population pop) {
        boolean monitorActive;
        boolean bl = monitorActive = a_conf.getMonitor() != null;
        if (a_conf.getMinimumPopSizePercent() > 0) {
            int sizeWanted = a_conf.getPopulationSize();
            int minSize = (int)Math.round((double)sizeWanted * (double)a_conf.getMinimumPopSizePercent() / 100.0);
            int popSize = pop.size();
            if (popSize < minSize) {
                IChromosome sampleChrom = a_conf.getSampleChromosome();
                Class<?> sampleChromClass = sampleChrom.getClass();
                IInitializer chromIniter = a_conf.getJGAPFactory().getInitializerFor(sampleChrom, sampleChromClass);
                while (pop.size() < minSize) {
                    try {
                        IChromosome newChrom = (IChromosome)chromIniter.perform(sampleChrom, sampleChromClass, null);
                        if (monitorActive) {
                            a_conf.getMonitor().event("before_add_chromosome", a_conf.getGenerationNr(), new Object[]{pop, newChrom});
                        }
                        pop.addChromosome(newChrom);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    public Configuration getLastConfiguration() {
        return this.m_lastConf;
    }

    public Population getLastPopulation() {
        return this.m_lastPop;
    }

    public Object clone() {
        return new GABreeder();
    }

    protected void keepPopSizeConstant(Population a_pop, Configuration a_conf) {
        if (a_conf.isKeepPopulationSizeConstant()) {
            try {
                a_pop.keepPopSizeConstant();
            }
            catch (InvalidConfigurationException iex) {
                throw new RuntimeException(iex);
            }
        }
    }

    protected IChromosome reAddFittest(Population a_pop, IChromosome a_fittest) {
        if (a_fittest != null && !a_pop.contains(a_fittest)) {
            a_pop.addChromosome(a_fittest);
            return a_fittest;
        }
        return null;
    }

    protected void updateChromosomes(Population a_pop, Configuration a_conf) {
        boolean bulkFitFunc;
        int currentPopSize = a_pop.size();
        BulkFitnessFunction bulkFunction = a_conf.getBulkFitnessFunction();
        boolean bl = bulkFitFunc = bulkFunction != null;
        if (!bulkFitFunc) {
            for (int i = 0; i < currentPopSize; ++i) {
                IChromosome chrom = a_pop.getChromosome(i);
                chrom.getFitnessValue();
            }
        }
    }

    private Population removeEvaluatedChromosomes(Population a_from_pop, Configuration a_config) throws InvalidConfigurationException {
        Population to_pop = new Population(a_config);
        for (int i = 0; i < a_from_pop.size(); ++i) {
            IChromosome selectedChromosome = a_from_pop.getChromosome(i);
            if (selectedChromosome.getFitnessValueDirectly() != -1.0) continue;
            to_pop.addChromosome(selectedChromosome);
        }
        return to_pop;
    }

    private Population removeChromosomesWithoutFitnessValue(Population a_from_pop, Configuration a_config) throws InvalidConfigurationException {
        Population to_pop = new Population(a_config);
        for (int i = 0; i < a_from_pop.size(); ++i) {
            IChromosome selectedChromosome = a_from_pop.getChromosome(i);
            if (selectedChromosome.getFitnessValueDirectly() == -1.0) continue;
            to_pop.addChromosome(selectedChromosome);
        }
        return to_pop;
    }

    public Population bulkFunctionEvaluation(Configuration a_conf, BulkFitnessFunction a_bulkFunction, Population a_pop, boolean a_monitorActive) throws InvalidConfigurationException {
        if (a_bulkFunction != null) {
            if (a_monitorActive) {
                a_conf.getMonitor().event("before_bulk_eval", a_conf.getGenerationNr(), new Object[]{a_bulkFunction, a_pop});
            }
            Population popForBulkFunction = this.removeEvaluatedChromosomes(a_pop, a_conf);
            if (!this.m_allChromosomesSoFar.isEmpty()) {
                Iterator<IChromosome> it = popForBulkFunction.getChromosomes().iterator();
                while (it.hasNext()) {
                    IChromosome iChromosome = it.next();
                    if (!this.m_allChromosomesSoFar.contains(iChromosome)) continue;
                    it.remove();
                }
            }
            this.fillPopulationRandomlyToOriginalSize(a_conf, popForBulkFunction);
            this.keepPopSizeConstant(popForBulkFunction, a_conf);
            if (popForBulkFunction.size() > 0) {
                a_bulkFunction.evaluate(popForBulkFunction);
            }
            for (Chromosome chromosome : popForBulkFunction.getChromosomes()) {
                Chromosome chrom = (Chromosome)chromosome.clone();
                chrom.setFitnessValueDirectly(-1.0);
                this.m_allChromosomesSoFar.add(chrom);
                if (a_pop.getChromosomes().contains(chromosome)) continue;
                a_pop.addChromosome(chromosome);
            }
            a_pop = this.removeChromosomesWithoutFitnessValue(a_pop, a_conf);
            if (a_monitorActive) {
                a_conf.getMonitor().event("after_bulk_eval", a_conf.getGenerationNr(), new Object[]{a_bulkFunction, a_pop});
            }
        }
        return a_pop;
    }
}

