/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.impl.NumberGene;
import org.jgap.impl.StockRandomGenerator;

public class IntegerGene
extends NumberGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.46 $";
    protected static final long INTEGER_RANGE = 0xFFFFFFFFL;
    private int m_upperBounds;
    private int m_lowerBounds;

    public IntegerGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public IntegerGene(Configuration a_config) throws InvalidConfigurationException {
        this(a_config, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerGene(Configuration a_config, int a_lowerBounds, int a_upperBounds) throws InvalidConfigurationException {
        super(a_config);
        this.m_lowerBounds = a_lowerBounds;
        this.m_upperBounds = a_upperBounds;
    }

    protected Gene newGeneInternal() {
        try {
            IntegerGene result = new IntegerGene(this.getConfiguration(), this.m_lowerBounds, this.m_upperBounds);
            return result;
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public String getPersistentRepresentation() {
        String s = this.getInternalValue() == null ? "null" : this.getInternalValue().toString();
        return s + ":" + this.m_lowerBounds + ":" + this.m_upperBounds;
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation  is not recognized: it does not contain three tokens: " + a_representation);
            }
            String valueRepresentation = tokenizer.nextToken();
            String lowerBoundRepresentation = tokenizer.nextToken();
            String upperBoundRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.setAllele(null);
            } else {
                try {
                    this.setAllele(new Integer(Integer.parseInt(valueRepresentation)));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            try {
                this.m_lowerBounds = Integer.parseInt(lowerBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_upperBounds = Integer.parseInt(upperBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
        }
    }

    public int intValue() {
        return (Integer)this.getAllele();
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        double randomValue = (double)((long)this.m_upperBounds - (long)this.m_lowerBounds) * a_numberGenerator.nextDouble() + (double)this.m_lowerBounds;
        this.setAllele(new Integer((int)Math.round(randomValue)));
    }

    protected int compareToNative(Object a_o1, Object a_o2) {
        return ((Integer)a_o1).compareTo((Integer)a_o2);
    }

    protected void mapValueToWithinBounds() {
        Integer i_value;
        if (this.getAllele() != null && ((i_value = (Integer)this.getAllele()) > this.m_upperBounds || i_value < this.m_lowerBounds)) {
            RandomGenerator rn = this.getConfiguration() != null ? this.getConfiguration().getRandomGenerator() : new StockRandomGenerator();
            if (this.m_upperBounds == this.m_lowerBounds) {
                this.setAllele(new Integer(this.m_lowerBounds));
            } else {
                this.setToRandomValue(rn);
            }
        }
    }

    public void applyMutation(int a_index, double a_percentage) {
        double range = (double)((long)this.m_upperBounds - (long)this.m_lowerBounds) * a_percentage;
        if (this.getAllele() == null) {
            this.setAllele(new Integer((int)range + this.m_lowerBounds));
        } else {
            int newValue = (int)Math.round((double)this.intValue() + range);
            this.setAllele(new Integer(newValue));
        }
    }

    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -1;
        }
        return super.hashCode();
    }

    public String toString() {
        String s = "IntegerGene(" + this.m_lowerBounds + "," + this.m_upperBounds + ")" + "=";
        s = this.getInternalValue() == null ? s + "null" : s + this.getInternalValue().toString();
        return s;
    }

    public int getLowerBounds() {
        return this.m_lowerBounds;
    }

    public int getUpperBounds() {
        return this.m_upperBounds;
    }
}

