/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jgap.BaseGene;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.ICompareToHandler;
import org.jgap.IPersistentRepresentation;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class SetGene
extends BaseGene
implements IPersistentRepresentation {
    private static final String CVS_REVISION = "$Revision: 1.18 $";
    private THashSet m_geneSet = new THashSet();
    private Object m_value;

    public SetGene() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public SetGene(Configuration a_conf) throws InvalidConfigurationException {
        super(a_conf);
    }

    protected Gene newGeneInternal() {
        try {
            return new SetGene(this.getConfiguration());
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
    }

    public void addAllele(Object a_value) {
        this.m_geneSet.add(a_value);
    }

    public void addAlleles(Collection a_alleles) {
        this.m_geneSet.addAll(a_alleles);
    }

    public void removeAlleles(Object a_key) {
        this.m_geneSet.remove(a_key);
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.m_value = this.m_geneSet.toArray()[a_numberGenerator.nextInt(this.m_geneSet.size())];
    }

    public void applyMutation(int a_index, double a_percentage) {
        RandomGenerator rn = this.getConfiguration() != null ? this.getConfiguration().getRandomGenerator() : this.getConfiguration().getJGAPFactory().createRandomGenerator();
        this.setToRandomValue(rn);
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() < 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it must contain at least three tokens.");
            }
            String valueRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.m_value = null;
            } else {
                try {
                    this.m_value = new Integer(Integer.parseInt(valueRepresentation));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            while (tokenizer.hasMoreTokens()) {
                try {
                    Integer allele = new Integer(Integer.parseInt(tokenizer.nextToken()));
                    this.m_geneSet.add((Object)allele);
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: a member of the list of eligible values does not appear to be an integer value.");
                }
            }
        }
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        Iterator it = this.m_geneSet.iterator();
        StringBuffer strbf = new StringBuffer();
        while (it.hasNext()) {
            strbf.append(":");
            strbf.append(it.next().toString());
        }
        return this.m_value.toString() + strbf.toString();
    }

    public void setAllele(Object a_newValue) {
        if (!this.m_geneSet.contains(a_newValue)) {
            throw new IllegalArgumentException("Allele value being set is not an element of the set of permitted values.");
        }
        this.m_value = a_newValue;
    }

    public int compareTo(Object other) {
        SetGene otherGene = (SetGene)other;
        if (otherGene == null) {
            return 1;
        }
        if (otherGene.m_value == null) {
            return this.m_value == null ? 0 : 1;
        }
        ICompareToHandler handler = this.getConfiguration().getJGAPFactory().getCompareToHandlerFor(this.m_value, this.m_value.getClass());
        if (handler != null) {
            try {
                return (Integer)handler.perform(this.m_value, null, otherGene.m_value);
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
        }
        return 0;
    }

    protected Object getInternalValue() {
        return this.m_value;
    }

    public int hashCode() {
        if (this.getInternalValue() == null) {
            return -67;
        }
        return super.hashCode();
    }
}

