/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class ClassKit {
    private static final String CVS_REVISION = "$Revision: 1.10 $";
    private static transient Logger LOGGER = Logger.getLogger(ClassKit.class);

    public static void main(String[] args) throws Exception {
        File f = new File(".");
        ClassKit.getPlugins(f.getCanonicalPath() + "\\lib");
    }

    public static List find(String a_tosubclassname) {
        try {
            Vector result = new Vector();
            Class<?> tosubclass = Class.forName(a_tosubclassname);
            Package[] pcks = Package.getPackages();
            for (int i = 0; i < pcks.length; ++i) {
                List subresult = ClassKit.find(pcks[i].getName(), tosubclass);
                result.addAll(subresult);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.warn((Object)("Class " + a_tosubclassname + " not found!"));
            return null;
        }
    }

    public static List find(String a_pckname, String a_tosubclassname) throws ClassNotFoundException {
        Class<?> tosubclass = Class.forName(a_tosubclassname);
        return ClassKit.find(a_pckname, tosubclass);
    }

    public static List find(String a_pckgname, Class a_tosubclass) {
        URL url;
        Vector result = new Vector();
        String name = a_pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if ((url = ClassKit.class.getResource(name = name.replace('.', '/'))) == null) {
            return result;
        }
        return ClassKit.find(url, a_pckgname, a_tosubclass);
    }

    public static List find(URL a_url, String a_pckgname, Class a_tosubclass) {
        Vector<String> result = new Vector<String>();
        File directory = new File(a_url.getFile());
        if (directory.exists()) {
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".class")) continue;
                String classname = files[i].substring(0, files[i].length() - 6);
                try {
                    Class<?> c = Class.forName(a_pckgname + "." + classname);
                    if (!ClassKit.implementsInterface(c, a_tosubclass) && !ClassKit.extendsClass(c, a_tosubclass)) continue;
                    result.add(a_pckgname + "." + classname);
                    continue;
                }
                catch (ClassNotFoundException cnfex) {
                    LOGGER.error((Object)cnfex);
                }
            }
        } else {
            ClassKit.findInJar(result, a_url, a_tosubclass);
        }
        return result;
    }

    public static void findInJar(List a_result, URL a_url, Class a_tosubclass) {
        try {
            JarURLConnection conn = (JarURLConnection)a_url.openConnection();
            String starts = conn.getEntryName();
            JarFile jfile = conn.getJarFile();
            Enumeration<JarEntry> e = jfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryname = entry.getName();
                if (!entryname.startsWith(starts) || entryname.lastIndexOf(47) > starts.length() || !entryname.endsWith(".class")) continue;
                String classname = entryname.substring(0, entryname.length() - 6);
                if (classname.startsWith("/")) {
                    classname = classname.substring(1);
                }
                classname = classname.replace('/', '.');
                try {
                    Class<?> c = Class.forName(classname);
                    if (!ClassKit.implementsInterface(c, a_tosubclass) && !ClassKit.extendsClass(c, a_tosubclass)) continue;
                    a_result.add(classname);
                }
                catch (ClassNotFoundException cnfex) {
                    LOGGER.error((Object)cnfex);
                }
            }
        }
        catch (IOException ioex) {
            LOGGER.error((Object)ioex);
        }
    }

    public static boolean implementsInterface(Class a_o, Class a_clazz) {
        Class<?>[] interfaces = a_o.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            if (!c.equals(a_clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean extendsClass(Class a_o, Class a_clazz) {
        if (a_clazz.getName().equals(a_o.getName())) {
            return false;
        }
        return a_clazz.isAssignableFrom(a_o);
    }

    public static void getPlugins(String a_directory) {
        File modulePath = new File(a_directory);
        File[] jarFiles = modulePath.listFiles(new ExtensionsFilter("jar", false));
        URL[] urls = new URL[jarFiles.length + 1];
        for (int i = 0; i < jarFiles.length; ++i) {
            try {
                urls[i] = jarFiles[i].toURL();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            urls[i] = modulePath.toURL();
        }
        catch (Exception ex) {
            // empty catch block
        }
        URLClassLoader ucl = new URLClassLoader(urls);
        Vector classes = new Vector();
        long startTime = System.currentTimeMillis();
        ClassKit.addClasses(classes, modulePath, "");
        LOGGER.info((Object)("Found plugin classes in: " + (System.currentTimeMillis() - startTime) + " milliseconds"));
        Enumeration e = classes.elements();
        while (e.hasMoreElements()) {
            try {
                String name = e.nextElement().toString();
                LOGGER.info((Object)("Found plugin class: " + name));
            }
            catch (Throwable ex) {}
        }
    }

    public static void addClasses(Vector a_v, File a_path, String a_name) {
        ClassKit.addClassesFile(a_v, a_path, a_name);
        ClassKit.addClassesJar(a_v, a_path);
    }

    public static void addClassesJar(Vector a_v, File a_path) {
        File[] files = a_path.listFiles(new ExtensionsFilter("jar", false));
        for (int i = 0; i < files.length; ++i) {
            try {
                JarFile jar = new JarFile(files[i]);
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    String wa = ((Object)e.nextElement()).toString();
                    if (!wa.endsWith(".class") || wa.indexOf("$") != -1) continue;
                    a_v.add(wa.substring(0, wa.length() - 6).replace('/', '.'));
                }
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static void addClassesFile(Vector a_v, File a_path, String a_name) {
        File[] files = a_path.listFiles(new ExtensionsFilter("class", true));
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ClassKit.addClassesFile(a_v, files[i], a_name + files[i].getName() + ".");
                continue;
            }
            if (files[i].getName().indexOf("$") != -1) continue;
            a_v.add(a_name + files[i].getName().substring(0, files[i].getName().length() - 6));
        }
    }

    static class ExtensionsFilter
    implements FilenameFilter {
        private String m_ext;

        public ExtensionsFilter(String a_extension, boolean a_dummy) {
            this.m_ext = a_extension;
        }

        public boolean accept(File a_dir, String a_name) {
            return a_name != null && a_name.endsWith("." + this.m_ext);
        }
    }
}

