/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgap.util.JarClassLoader;

public class FileKit {
    private static final String CVS_REVISION = "$Revision: 1.12 $";
    public static String fileseparator = System.getProperty("file.separator");

    public static void copyFile(String source, String dest) throws FileNotFoundException, IOException {
        FileKit.copyFile(source, dest, 0);
    }

    public static void copyFile(String source, String dest, int a_offset) throws FileNotFoundException, IOException {
        int c;
        if (FileKit.getFilename(dest).length() == 0) {
            dest = dest + FileKit.getFilename(source);
        }
        File inputFile = new File(source);
        File outputFile = new File(dest);
        FileInputStream in = new FileInputStream(inputFile);
        FileOutputStream out = new FileOutputStream(outputFile);
        int currentOffset = 0;
        while ((c = in.read()) != -1) {
            if (currentOffset >= a_offset) {
                out.write(c);
            }
            ++currentOffset;
        }
        in.close();
        out.close();
    }

    public static String getFilename(String name_and_path) {
        return FileKit.getFilename(name_and_path, fileseparator);
    }

    public static String getFilename(String name_and_path, String fileseparator) {
        if (name_and_path == null) {
            return "";
        }
        String s = name_and_path;
        s = fileseparator.equals("/") ? s.replace('\\', '/') : s.replace('/', '\\');
        int p = s.lastIndexOf(fileseparator);
        if (p < 0) {
            return s;
        }
        if ((s = s.substring(p + 1)) == null) {
            s = "";
        }
        return s;
    }

    public static String getCurrentDir() throws IOException {
        File file = new File(".");
        return file.getCanonicalPath();
    }

    public static String addSubDir(String dir, String subDir, boolean makeNice) {
        File f = new File(FileKit.getConformPath(dir, true), subDir);
        String s = FileKit.getConformPath(f.getAbsolutePath(), makeNice);
        return s;
    }

    public static String addFilename(String dir, String a_filename) {
        File f = new File(FileKit.getConformPath(dir, false), a_filename);
        return f.getAbsolutePath();
    }

    public static String getConformPath(String path, boolean makeNice) {
        if (makeNice) {
            return FileKit.getNiceURL(FileKit.getConformPath(path), fileseparator);
        }
        return FileKit.getConformPath(path);
    }

    public static String getConformPath(String path) {
        return FileKit.getConformPath(path, fileseparator);
    }

    public static String getConformPath(String path, String a_fileseparator) {
        String result = path;
        result = a_fileseparator.equals("/") ? FileKit.removeDoubleSeparators(path.replace('\\', '/')) : FileKit.removeDoubleSeparators(path.replace('/', '\\'));
        if (!result.endsWith(a_fileseparator)) {
            result = result + a_fileseparator;
        }
        return result;
    }

    public static String getNiceURL(String url, String separator) {
        if (url == null) {
            return null;
        }
        if (url.length() == 0) {
            return separator;
        }
        int p = url.lastIndexOf(separator);
        if (p < url.length() - 1) {
            return FileKit.removeDoubleSeparators(url + separator);
        }
        return FileKit.removeDoubleSeparators(url);
    }

    public static String removeDoubleSeparators(String dir) {
        String sep;
        int p;
        while ((p = dir.lastIndexOf(sep = fileseparator.length() > 1 ? fileseparator : fileseparator + fileseparator)) >= 0) {
            dir = dir.substring(0, p) + dir.substring(p + 1);
        }
        return dir;
    }

    public static boolean directoryExists(String a_dir) {
        File f = new File(a_dir);
        return f.exists();
    }

    public static boolean existsFile(String a_filename) {
        File file = new File(FileKit.getConformPath(a_filename));
        return file.exists();
    }

    public static boolean deleteFile(String a_filename) {
        File file = new File(FileKit.getConformPath(a_filename));
        return FileKit.deleteFile(file);
    }

    public static boolean deleteFile(File a_file) {
        if (a_file.exists()) {
            return a_file.delete();
        }
        return false;
    }

    public static boolean deleteDirectory(File a_dir) {
        if (a_dir.isDirectory()) {
            String[] children = a_dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileKit.deleteDirectory(new File(a_dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return a_dir.delete();
    }

    public static ClassLoader loadJar(String a_filename) throws Exception {
        JarClassLoader cl = new JarClassLoader(a_filename);
        return cl;
    }

    public static Manifest getManifestOfJar(String a_filename) throws Exception {
        URL url = new URL("jar:file:" + a_filename + "!/");
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        Manifest manifest = jarConnection.getManifest();
        jarConnection.getJarFile().close();
        return manifest;
    }

    public static String getJGAPVersion(Manifest a_JGAPManifest) {
        Attributes attr = a_JGAPManifest.getMainAttributes();
        return attr.getValue("JGAP-Version");
    }

    public static String getModuleVersion(Manifest a_JGAPManifest) {
        Attributes attr = a_JGAPManifest.getMainAttributes();
        return attr.getValue("Module-Version");
    }

    public static String getVersionOfModule(String a_filename) throws Exception {
        Manifest mf = FileKit.getManifestOfJar(a_filename);
        String version = FileKit.getModuleVersion(mf);
        if (version == null) {
            version = "no version info found!";
        }
        return version;
    }

    public static String getVersionOfJGAP(String a_filename) throws Exception {
        Manifest mf = FileKit.getManifestOfJar(a_filename);
        String version = FileKit.getJGAPVersion(mf);
        if (version == null) {
            version = "no version info found!";
        }
        return version;
    }

    public static String toJarFileName(String a_filename) {
        String result = a_filename.replace('\\', '/');
        return result;
    }

    public static void createDirectory(String a_dirname) throws IOException {
        File file = new File(a_dirname);
        if (file.exists()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new IOException("Directory " + a_dirname + " could not be created!");
        }
    }

    public static Vector readFile(String a_filename) throws IOException {
        String thisLine;
        Vector<String> v = new Vector<String>();
        FileInputStream fin = new FileInputStream(a_filename);
        BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
        while ((thisLine = myInput.readLine()) != null) {
            v.add(thisLine);
        }
        return v;
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String[] listFilesInDir(String a_dir, String a_mask) throws Exception {
        File f = new File(a_dir);
        return f.list(new MyFileNameFilter(a_dir, a_mask));
    }

    static class MyFileNameFilter
    implements FilenameFilter {
        private String m_dir;
        private String m_mask;

        public MyFileNameFilter(String a_dir, String a_mask) {
            this.m_dir = a_dir;
            this.m_mask = a_mask == null || a_mask.length() < 1 ? null : a_mask;
        }

        public boolean accept(File dir, String name) {
            if (this.m_dir.equals(FileKit.getConformPath(dir.getPath()))) {
                if (this.m_mask == null) {
                    return true;
                }
                Pattern p = Pattern.compile(this.m_mask);
                Matcher m = p.matcher(name);
                return m.matches();
            }
            return false;
        }
    }
}

