/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.quality.KMeansQualityMeasure;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;

public class WithinClusterMeanDistanceQualityMeasure
implements KMeansQualityMeasure<NumberVector> {
    @Override
    public <V extends NumberVector> double quality(Clustering<? extends MeanModel> clustering, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, Relation<V> relation) {
        double d = 0.0;
        for (Cluster<? extends MeanModel> cluster : clustering.getAllClusters()) {
            DBIDs dBIDs = cluster.getIDs();
            double d2 = 0.0;
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
                DBIDIter dBIDIter2 = dBIDs.iter();
                while (dBIDIter2.valid()) {
                    d2 += numberVectorDistanceFunction.distance(numberVector, (NumberVector)relation.get(dBIDIter2));
                    dBIDIter2.advance();
                }
                dBIDIter.advance();
            }
            d += d2 / (double)(dBIDs.size() * dBIDs.size());
        }
        return d / (double)clustering.getAllClusters().size();
    }

    @Override
    public boolean ascending() {
        return false;
    }

    @Override
    public boolean isBetter(double d, double d2) {
        return !(d >= d2);
    }
}

