/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="KNNWeight outlier detection")
@Description(value="Outlier detection based on the sum of distances of an object to its k nearest neighbors.")
@Reference(authors="F. Angiulli, C. Pizzuti", title="Fast Outlier Detection in High Dimensional Spaces", booktitle="Proc. European Conference on Principles of Knowledge Discovery and Data Mining (PKDD'02), Helsinki, Finland, 2002", url="http://dx.doi.org/10.1007/3-540-45681-3_2")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.KNNWeightOutlier", "knnw"})
public class KNNWeightOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNWeightOutlier.class);
    private int k;

    public KNNWeightOutlier(DistanceFunction<? super O> distanceFunction, int n) {
        super(distanceFunction);
        this.k = n;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        Object object;
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> kNNQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Compute kNN weights", relation.size(), LOG) : null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = kNNQuery.getKNNForDBID((DBIDRef)object2, this.k + 1);
            double d = 0.0;
            int n = 0;
            DoubleDBIDListIter doubleDBIDListIter = object.iter();
            while (n < this.k && doubleDBIDListIter.valid()) {
                if (!DBIDUtil.equal((DBIDRef)object2, doubleDBIDListIter)) {
                    d += doubleDBIDListIter.doubleValue();
                    ++n;
                }
                doubleDBIDListIter.advance();
            }
            if (n < this.k) {
                d = Double.POSITIVE_INFINITY;
            }
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            doubleMinMax.put(d);
            LOG.incrementProcessed(finiteProgress);
            object2.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        object2 = new MaterializedDoubleRelation("kNN weight Outlier Score", "knnw-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new BasicOutlierScoreMeta(doubleMinMax.getMin(), doubleMinMax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("knnwod.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected int k;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.k = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected KNNWeightOutlier<O> makeInstance() {
            return new KNNWeightOutlier(this.distanceFunction, this.k);
        }
    }
}

