/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.database.AbstractDatabase;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleWriter;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class ConvertToBundleApplication
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(ConvertToBundleApplication.class);
    private DatabaseConnection input;
    private File outfile;

    public ConvertToBundleApplication(DatabaseConnection databaseConnection, File file) {
        this.input = databaseConnection;
        this.outfile = file;
    }

    @Override
    public void run() throws UnableToComplyException {
        if (LOG.isVerbose()) {
            LOG.verbose("Loading data.");
        }
        MultipleObjectsBundle multipleObjectsBundle = this.input.loadData();
        if (LOG.isVerbose()) {
            LOG.verbose("Serializing to output file: " + this.outfile.toString());
        }
        BundleWriter bundleWriter = new BundleWriter();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outfile);
            FileChannel fileChannel = fileOutputStream.getChannel();
            bundleWriter.writeBundleStream(multipleObjectsBundle.asStream(), fileChannel);
            fileChannel.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LOG.exception("IO Error", iOException);
        }
    }

    public static void main(String[] stringArray) {
        ConvertToBundleApplication.runCLIApplication(ConvertToBundleApplication.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        private DatabaseConnection input;
        private File outfile;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(AbstractDatabase.Parameterizer.DATABASE_CONNECTION_ID, (Class<?>)DatabaseConnection.class, FileBasedDatabaseConnection.class);
            if (parameterization.grab(objectParameter)) {
                this.input = (DatabaseConnection)objectParameter.instantiateClass(parameterization);
            }
            this.outfile = super.getParameterOutputFile(parameterization, "File name to serialize the bundle to.");
        }

        @Override
        protected ConvertToBundleApplication makeInstance() {
            return new ConvertToBundleApplication(this.input, this.outfile);
        }
    }
}

