/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.transform.ClassicMultidimensionalScalingTransform;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;
import java.util.Random;

@Alias(value={"fastmds"})
public class FastMultidimensionalScalingTransform<O>
implements ObjectFilter {
    private static final Logging LOG = Logging.getLogger(FastMultidimensionalScalingTransform.class);
    PrimitiveDistanceFunction<? super O> dist = null;
    int tdim;

    public FastMultidimensionalScalingTransform(int n, PrimitiveDistanceFunction<? super O> primitiveDistanceFunction) {
        this.tdim = n;
        this.dist = primitiveDistanceFunction;
    }

    @Override
    public MultipleObjectsBundle filter(MultipleObjectsBundle multipleObjectsBundle) {
        int n = multipleObjectsBundle.dataLength();
        if (n == 0) {
            return multipleObjectsBundle;
        }
        MultipleObjectsBundle multipleObjectsBundle2 = new MultipleObjectsBundle();
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            Object object;
            Object object2;
            SimpleTypeInformation<?> simpleTypeInformation = multipleObjectsBundle.meta(i);
            List<?> list = multipleObjectsBundle.getColumn(i);
            if (!this.dist.getInputTypeRestriction().isAssignableFromType(simpleTypeInformation)) {
                multipleObjectsBundle2.appendColumn(simpleTypeInformation, list);
                continue;
            }
            List<?> list2 = list;
            NumberVector.Factory<DoubleVector> factory = null;
            if (simpleTypeInformation instanceof VectorFieldTypeInformation) {
                object = object2 = (VectorFieldTypeInformation)simpleTypeInformation;
                factory = FilterUtil.guessFactory(object);
            } else {
                factory = DoubleVector.FACTORY;
            }
            multipleObjectsBundle2.appendColumn(new VectorFieldTypeInformation<DoubleVector>(factory, this.tdim), list2);
            object2 = this.computeDistanceMatrix(list2);
            ClassicMultidimensionalScalingTransform.doubleCenterSymmetric((double[][])object2);
            object = new double[this.tdim][n];
            double[] dArray = new double[this.tdim];
            this.findEigenVectors((double[][])object2, (double[][])object, dArray);
            double[] dArray2 = new double[this.tdim];
            for (int j = 0; j < n; ++j) {
                for (int k = 0; k < this.tdim; ++k) {
                    dArray2[k] = dArray[k] * object[k][j];
                }
                list.set(j, factory.newNumberVector(dArray2));
            }
        }
        return multipleObjectsBundle2;
    }

    protected double[][] computeDistanceMatrix(List<O> list) {
        int n = list.size();
        double[][] dArray = new double[n][n];
        boolean bl = this.dist instanceof SquaredEuclideanDistanceFunction;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Computing distance matrix", n * (n - 1) >>> 1, LOG) : null;
        for (int i = 0; i < n; ++i) {
            O o = list.get(i);
            for (int j = i + 1; j < n; ++j) {
                O o2 = list.get(j);
                double d = this.dist.distance(o, o2);
                dArray[i][j] = d *= bl ? -0.5 : -0.5 * d;
                dArray[j][i] = d;
            }
            if (finiteProgress == null) continue;
            finiteProgress.setProcessed(finiteProgress.getProcessed() + n - i - 1, LOG);
        }
        LOG.ensureCompleted(finiteProgress);
        return dArray;
    }

    protected void findEigenVectors(double[][] dArray, double[][] dArray2, double[] dArray3) {
        int n = dArray.length;
        Random random = new Random();
        double[] dArray4 = new double[n];
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Learning projections", this.tdim, LOG) : null;
        int n2 = 0;
        while (n2 < this.tdim) {
            double d;
            double[] dArray5 = dArray2[n2];
            this.randomInitialization(dArray5, random);
            double d2 = this.multiply(dArray, dArray5, dArray4);
            for (int i = 0; i < 100 && !((d = this.updateEigenvector(dArray4, dArray5, d2)) < 1.0E-10); ++i) {
                d2 = this.multiply(dArray, dArray5, dArray4);
            }
            dArray3[n2] = d2 = this.estimateEigenvalue(dArray, dArray5);
            LOG.incrementProcessed(finiteProgress);
            if (++n2 == this.tdim) break;
            this.updateMatrix(dArray, dArray5, d2);
        }
        LOG.ensureCompleted(finiteProgress);
    }

    protected void randomInitialization(double[] dArray, Random random) {
        double d = 0.0;
        while (!(d > 0.0)) {
            for (int i = 0; i < dArray.length; ++i) {
                double d2;
                dArray[i] = d2 = random.nextDouble();
                d += d2 * d2;
            }
        }
        if (!(d > 0.0)) {
            this.randomInitialization(dArray, random);
            return;
        }
        double d3 = 1.0 / Math.sqrt(d);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d3;
        }
    }

    protected double multiply(double[][] dArray, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            double[] dArray4 = dArray[i];
            double d2 = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                d2 += dArray4[j] * dArray2[j];
            }
            dArray3[i] = d2;
            d += d2 * d2;
        }
        return d > 0.0 ? Math.sqrt(d) : 0.0;
    }

    protected double updateEigenvector(double[] dArray, double[] dArray2, double d) {
        double d2 = 1.0 / (d > 0.0 ? d : (d < 0.0 ? -d : 1.0));
        d2 = dArray[0] > 0.0 ? d2 : -d2;
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] * d2;
            double d4 = dArray[i] - dArray2[i];
            d3 += d4 * d4;
            dArray2[i] = dArray[i];
        }
        return d3;
    }

    protected double estimateEigenvalue(double[][] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            double[] dArray3 = dArray[i];
            double d3 = 0.0;
            for (int j = 0; j < dArray2.length; ++j) {
                d3 += dArray3[j] * dArray2[j];
            }
            double d4 = dArray2[i];
            d += d3 * d4;
            d2 += d4 * d4;
        }
        return d / d2;
    }

    protected void updateMatrix(double[][] dArray, double[] dArray2, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double d2 = dArray2[i];
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                dArray3[n2] = dArray3[n2] - d * d2 * dArray2[j];
            }
        }
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        int tdim;
        PrimitiveDistanceFunction<? super O> dist = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(ClassicMultidimensionalScalingTransform.Parameterizer.DIM_ID);
            if (parameterization.grab(intParameter)) {
                this.tdim = intParameter.intValue();
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(ClassicMultidimensionalScalingTransform.Parameterizer.DISTANCE_ID, (Class<?>)PrimitiveDistanceFunction.class, SquaredEuclideanDistanceFunction.class))) {
                this.dist = (PrimitiveDistanceFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected FastMultidimensionalScalingTransform<O> makeInstance() {
            return new FastMultidimensionalScalingTransform<O>(this.tdim, this.dist);
        }
    }
}

