/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.AbstractVectorSimilarityFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

public class LaplaceKernelFunction
extends AbstractVectorSimilarityFunction {
    private final double mgamma;

    public LaplaceKernelFunction(double d) {
        this.mgamma = -0.5 / (d * d);
    }

    @Override
    public double similarity(NumberVector numberVector, NumberVector numberVector2) {
        int n = AbstractNumberVectorDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = numberVector.doubleValue(i) - numberVector2.doubleValue(i);
            d += d2 * d2;
        }
        return Math.exp(this.mgamma * Math.sqrt(d));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SIGMA_ID = new OptionID("kernel.laplace.sigma", "Standard deviation of the laplace RBF kernel.");
        protected double sigma = 1.0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(SIGMA_ID, 1.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.sigma = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LaplaceKernelFunction makeInstance() {
            return new LaplaceKernelFunction(this.sigma);
        }
    }
}

