/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.geometry;

import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Arrays;

@Reference(authors="R. C. Prim", title="Shortest connection networks and some generalizations", booktitle="Bell System Technical Journal, 36 (1957)")
public class PrimsMinimumSpanningTree {
    public static final Array2DAdapter ARRAY2D_ADAPTER = new Array2DAdapter();

    public static int[] processDense(double[][] dArray) {
        return PrimsMinimumSpanningTree.processDense(dArray, ARRAY2D_ADAPTER);
    }

    public static int[] processDense(Matrix matrix) {
        return PrimsMinimumSpanningTree.processDense(matrix.getArrayRef(), ARRAY2D_ADAPTER);
    }

    public static <T> int[] processDense(T t, Adapter<T> adapter) {
        int n = adapter.size(t);
        int[] nArray = new int[n - 1 << 1];
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        int[] nArray2 = new int[n];
        byte[] byArray = new byte[n];
        int n2 = 0;
        byArray[0] = 1;
        dArray[n2] = 0.0;
        for (int i = n - 2; i >= 0; --i) {
            int n3 = -1;
            double d = Double.POSITIVE_INFINITY;
            for (int j = 0; j < n; ++j) {
                if (byArray[j] == 1) continue;
                double d2 = adapter.distance(t, n2, j);
                if (d2 < dArray[j]) {
                    dArray[j] = d2;
                    nArray2[j] = n2;
                }
                if (!(dArray[j] < d)) continue;
                d = dArray[j];
                n3 = j;
            }
            assert (n3 >= 0);
            byArray[n3] = 1;
            nArray[i << 1] = n3;
            nArray[(i << 1) + 1] = nArray2[n3];
            n2 = n3;
        }
        return nArray;
    }

    public static <T> void processDense(T t, Adapter<T> adapter, Collector collector) {
        int n = adapter.size(t);
        double[] dArray = new double[n];
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        int[] nArray = new int[n];
        byte[] byArray = new byte[n];
        int n2 = 0;
        byArray[n2] = 1;
        dArray[n2] = 0.0;
        for (int i = n - 2; i >= 0; --i) {
            int n3 = -1;
            double d = Double.POSITIVE_INFINITY;
            for (int j = 1; j < n; ++j) {
                if (byArray[j] == 1) continue;
                double d2 = adapter.distance(t, n2, j);
                if (d2 < dArray[j]) {
                    dArray[j] = d2;
                    nArray[j] = n2;
                }
                if (!(dArray[j] < d)) continue;
                d = dArray[j];
                n3 = j;
            }
            assert (n3 >= 0);
            byArray[n3] = 1;
            collector.addEdge(d, nArray[n3], n3);
            n2 = n3;
        }
    }

    public static int[] pruneTree(int n, int[] nArray, int n2) {
        int n3;
        int n4;
        int[] nArray2 = new int[n];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            int n5 = nArray[n4];
            nArray2[n5] = nArray2[n5] + 1;
        }
        n4 = 0;
        for (n3 = 0; n3 < nArray.length; n3 += 2) {
            if (nArray2[nArray[n3]] < n2 || nArray2[nArray[n3 + 1]] < n2) continue;
            ++n4;
        }
        n3 = 0;
        int[] nArray3 = new int[n4];
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray2[nArray[i]] < n2 || nArray2[nArray[i + 1]] < n2) continue;
            nArray3[n3] = nArray[i];
            nArray3[n3 + 1] = nArray[i + 1];
            n3 += 2;
        }
        assert (n3 == nArray3.length);
        return nArray3;
    }

    public static class Array2DAdapter
    implements Adapter<double[][]> {
        private Array2DAdapter() {
        }

        @Override
        public double distance(double[][] dArray, int n, int n2) {
            return dArray[n][n2];
        }

        @Override
        public int size(double[][] dArray) {
            return dArray.length;
        }
    }

    public static interface Collector {
        public void addEdge(double var1, int var3, int var4);
    }

    public static interface Adapter<T> {
        public double distance(T var1, int var2, int var3);

        public int size(T var1);
    }
}

