/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class SkewGeneralizedNormalDistribution
extends AbstractDistribution {
    private double mean;
    private double stddev;
    private double skew;

    public SkewGeneralizedNormalDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.mean = d;
        this.stddev = d2;
        this.skew = d3;
    }

    public SkewGeneralizedNormalDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.mean = d;
        this.stddev = d2;
        this.skew = d3;
    }

    public SkewGeneralizedNormalDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return SkewGeneralizedNormalDistribution.pdf(d, this.mean, this.stddev, this.skew);
    }

    @Override
    public double cdf(double d) {
        return SkewGeneralizedNormalDistribution.cdf(d, this.mean, this.stddev, this.skew);
    }

    @Override
    public double quantile(double d) {
        return SkewGeneralizedNormalDistribution.quantile(d, this.mean, this.stddev, this.skew);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextGaussian();
        if (Math.abs(this.skew) > 0.0) {
            d = (1.0 - Math.exp(-this.skew * d)) / this.skew;
        }
        return this.mean + this.stddev * d;
    }

    @Override
    public String toString() {
        return "SkewNormalDistribution(mean=" + this.mean + ", stddev=" + this.stddev + ", skew=" + this.skew + ")";
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        if (Math.abs(d4) > 0.0) {
            d = -Math.log(1.0 - d4 * d) / d4;
        }
        return MathUtil.SQRTHALF * Math.exp(-0.5 * d * d) / d3 / (1.0 - d4 * d);
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        d = (d - d2) / d3;
        if (Math.abs(d4) > 0.0) {
            double d5 = 1.0 - d4 * d;
            if (d5 < 1.0E-15) {
                return d4 < 0.0 ? 0.0 : 1.0;
            }
            d = -Math.log(d5) / d4;
        }
        return 0.5 + 0.5 * NormalDistribution.erf(d * MathUtil.SQRTHALF);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        d = NormalDistribution.standardNormalQuantile(d);
        if (Math.abs(d4) > 0.0) {
            d = (1.0 - Math.exp(-d4 * d)) / d4;
        }
        return d2 + d3 * d;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SKEW_ID = new OptionID("distribution.skewgnormal.skew", "Skew of the distribution.");
        double mean;
        double sigma;
        double skew;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.mean = doubleParameter2.doubleValue();
            }
            DoubleParameter doubleParameter3 = new DoubleParameter(SCALE_ID);
            doubleParameter3.addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter3)) {
                this.sigma = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SKEW_ID))) {
                this.skew = doubleParameter.doubleValue();
            }
        }

        @Override
        protected SkewGeneralizedNormalDistribution makeInstance() {
            return new SkewGeneralizedNormalDistribution(this.mean, this.sigma, this.skew, this.rnd);
        }
    }
}

