/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SamplingResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import org.w3c.dom.Element;

public abstract class AbstractScatterplotVisualization
extends AbstractVisualization {
    protected final Projection2D proj;
    protected final Relation<? extends NumberVector> rel;
    protected final SamplingResult sample;

    public AbstractScatterplotVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        super(visualizationTask, visualizationPlot, d, d2);
        this.proj = (Projection2D)projection;
        this.rel = visualizationTask.getRelation();
        this.sample = visualizationTask.updateOnAny(8) ? ResultUtil.getSamplingResult(this.rel) : null;
    }

    protected Element setupCanvas() {
        double d = this.context.getStyleLibrary().getSize("margin");
        this.layer = AbstractScatterplotVisualization.setupCanvas(this.svgp, this.proj, d, this.getWidth(), this.getHeight());
        return this.layer;
    }

    public static Element setupCanvas(SVGPlot sVGPlot, Projection2D projection2D, double d, double d2, double d3) {
        CanvasSize canvasSize = projection2D.estimateViewport();
        double d4 = canvasSize.getDiffX();
        double d5 = canvasSize.getDiffY();
        String string = SVGUtil.makeMarginTransform(d2, d3, d4, d5, d) + " translate(" + SVGUtil.fmt(d4 * 0.5) + " " + SVGUtil.fmt(d5 * 0.5) + ")";
        Element element = SVGUtil.svgElement(sVGPlot.getDocument(), "g");
        SVGUtil.setAtt(element, "transform", string);
        return element;
    }

    @Override
    public void visualizationChanged(VisualizationItem visualizationItem) {
        super.visualizationChanged(visualizationItem);
        if (visualizationItem == this.proj) {
            this.svgp.requestRedraw(this.task, this);
            return;
        }
    }
}

