/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.result.ReferencePointsResult;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Iterator;
import org.w3c.dom.Element;

public class ReferencePointsVisualization
extends AbstractVisFactory {
    private static final String NAME = "Reference Points";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewResultVis(visualizerContext, object, ReferencePointsResult.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<ReferencePointsResult<?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, ReferencePointsResult<?> referencePointsResult, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(ReferencePointsVisualization.NAME, visualizerContext, referencePointsResult, relation, ReferencePointsVisualization.this);
                visualizationTask.level = 100;
                visualizerContext.addVis(referencePointsResult, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        public static final String REFPOINT = "refpoint";
        protected ReferencePointsResult<? extends NumberVector> result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (ReferencePointsResult)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            this.setupCSS(this.svgp);
            Iterator iterator = this.result.iterator();
            double d = styleLibrary.getSize("plot.referencepoints");
            while (iterator.hasNext()) {
                NumberVector numberVector = (NumberVector)iterator.next();
                double[] dArray = this.proj.fastProjectDataToRenderSpace(numberVector);
                Element element = this.svgp.svgCircle(dArray[0], dArray[1], d);
                SVGUtil.addCSSClass(element, REFPOINT);
                this.layer.appendChild(element);
            }
        }

        private void setupCSS(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            CSSClass cSSClass = new CSSClass(sVGPlot, REFPOINT);
            cSSClass.setStatement("fill", styleLibrary.getColor("plot.referencepoints"));
            sVGPlot.addCSSClassOrLogError(cSSClass);
        }
    }
}

